/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.WriteTransformerMetadata;
import org.eclipse.persistence.mappings.TransformationMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationAccessor
extends BasicAccessor {
    private ReadTransformerMetadata m_readTransformer;
    private List<WriteTransformerMetadata> m_writeTransformers;

    public TransformationAccessor() {
        super("<transformation>");
    }

    public TransformationAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object object;
        Object t;
        if (annotation != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", annotation));
        }
        if ((t = this.getAnnotation(ReadTransformer.class)) != null) {
            this.m_readTransformer = new ReadTransformerMetadata((Annotation)t, metadataAccessibleObject);
        }
        this.m_writeTransformers = new ArrayList<WriteTransformerMetadata>();
        Object t2 = this.getAnnotation(WriteTransformers.class);
        if (t2 != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t2);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t3 = object[i];
                this.m_writeTransformers.add(new WriteTransformerMetadata((Annotation)t3, metadataAccessibleObject));
            }
        }
        if ((object = this.getAnnotation(WriteTransformer.class)) != null) {
            this.m_writeTransformers.add(new WriteTransformerMetadata((Annotation)object, metadataAccessibleObject));
        }
    }

    public ReadTransformerMetadata getReadTransformer() {
        return this.m_readTransformer;
    }

    public List<WriteTransformerMetadata> getWriteTransformers() {
        return this.m_writeTransformers;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_readTransformer, metadataAccessibleObject);
        this.initXMLObjects(this.m_writeTransformers, metadataAccessibleObject);
    }

    @Override
    public void process() {
        TransformationMapping transformationMapping = new TransformationMapping();
        transformationMapping.setAttributeName(this.getAttributeName());
        transformationMapping.setIsOptional(this.isOptional());
        transformationMapping.setIsLazy(this.usesIndirection());
        if (this.getMutable() != null) {
            transformationMapping.setIsMutable(this.getMutable());
        }
        this.setAccessorMethods(transformationMapping);
        this.processProperties(transformationMapping);
        if (this.m_readTransformer != null) {
            this.m_readTransformer.process(transformationMapping, this.getAnnotatedElementName());
        }
        if (this.m_writeTransformers.isEmpty()) {
            transformationMapping.setIsReadOnly(true);
        } else {
            if (this.m_writeTransformers.size() == 1 && !this.m_writeTransformers.get(0).hasFieldName()) {
                this.m_writeTransformers.get(0).setFieldName(this.getAttributeName());
            }
            for (WriteTransformerMetadata writeTransformerMetadata : this.m_writeTransformers) {
                writeTransformerMetadata.process(transformationMapping, this.getAnnotatedElementName());
            }
        }
        this.getDescriptor().addMapping(transformationMapping);
    }

    public void setReadTransformer(ReadTransformerMetadata readTransformerMetadata) {
        this.m_readTransformer = readTransformerMetadata;
    }

    public void setWriteTransformers(List<WriteTransformerMetadata> list) {
        this.m_writeTransformers = list;
    }
}

