/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SimpleConditionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class BetweenNode
extends SimpleConditionalExpressionNode {
    protected Node rightForBetween;
    protected Node rightForAnd;

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(parseTreeContext);
        }
        if (this.rightForBetween != null) {
            this.rightForBetween = this.rightForBetween.qualifyAttributeAccess(parseTreeContext);
        }
        if (this.rightForAnd != null) {
            this.rightForAnd = this.rightForAnd.qualifyAttributeAccess(parseTreeContext);
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        Object object = null;
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            object = this.left.getType();
        }
        if (this.rightForBetween != null) {
            this.rightForBetween.validate(parseTreeContext);
            this.rightForBetween.validateParameter(parseTreeContext, object);
        }
        if (this.rightForAnd != null) {
            this.rightForAnd.validate(parseTreeContext);
            this.rightForAnd.validateParameter(parseTreeContext, object);
        }
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = expression.between(this.getRightForBetween().generateExpression(generationContext), this.getRightForAnd().generateExpression(generationContext));
        return expression;
    }

    public Node getRightForAnd() {
        return this.rightForAnd;
    }

    public Node getRightForBetween() {
        return this.rightForBetween;
    }

    public boolean hasRightForAnd() {
        return this.rightForAnd != null;
    }

    public boolean hasRightForBetween() {
        return this.rightForBetween != null;
    }

    public void setRightForAnd(Node node) {
        this.rightForAnd = node;
    }

    public void setRightForBetween(Node node) {
        this.rightForBetween = node;
    }
}

