/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class XMLRelationshipMappingNodeValue
extends MappingNodeValue {
    public void processChild(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes attributes, XMLDescriptor xMLDescriptor) throws SAXException {
        Serializable serializable;
        if (xMLDescriptor.hasInheritance()) {
            QName qName;
            unmarshalRecord.setAttributes(attributes);
            serializable = xMLDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, unmarshalRecord.getSession());
            if (serializable == null && (qName = unmarshalRecord.getLeafElementType()) != null) {
                Object v = xMLDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(qName);
                if (v == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(qName, xMLDescriptor.getInheritancePolicy().getDescriptor());
                }
                serializable = (Class)v;
            }
            if (serializable != null) {
                xMLDescriptor = (XMLDescriptor)unmarshalRecord.getSession().getDescriptor((Class)serializable);
            } else if (Modifier.isAbstract(xMLDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xMLDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        serializable = (TreeObjectBuilder)xMLDescriptor.getObjectBuilder();
        unmarshalRecord.setChildRecord((UnmarshalRecord)serializable.createRecord(unmarshalRecord.getSession()));
        unmarshalRecord.getChildRecord().setAttributes(attributes);
        unmarshalRecord.getChildRecord().setUnmarshaller(unmarshalRecord.getUnmarshaller());
        unmarshalRecord.getChildRecord().startDocument();
        unmarshalRecord.getChildRecord().startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), xPathFragment.getShortName(), attributes);
        unmarshalRecord.getXMLReader().setContentHandler(unmarshalRecord.getChildRecord());
        try {
            unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord.getChildRecord());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        unmarshalRecord.getChildRecord().setXMLReader(unmarshalRecord.getXMLReader());
    }

    protected XMLDescriptor findReferenceDescriptor(UnmarshalRecord unmarshalRecord, Attributes attributes, DatabaseMapping databaseMapping) {
        XMLDescriptor xMLDescriptor = null;
        XMLContext xMLContext = unmarshalRecord.getUnmarshaller().getXMLContext();
        String string = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (string != null && !string.equals("")) {
            XPathFragment xPathFragment = new XPathFragment();
            xPathFragment.setXPath(string);
            if (xPathFragment.hasNamespace()) {
                String string2 = xPathFragment.getPrefix();
                String string3 = unmarshalRecord.resolveNamespacePrefix(string2);
                xPathFragment.setNamespaceURI(string3);
            }
            xMLDescriptor = xMLContext.getDescriptorByGlobalType(xPathFragment);
        } else {
            QName qName = ((XMLField)databaseMapping.getField()).getLastXPathFragment().getLeafElementType();
            if (qName != null) {
                XPathFragment xPathFragment = new XPathFragment();
                String string4 = qName.getLocalPart();
                String string5 = qName.getNamespaceURI();
                if (string5 != null && !string5.equals("")) {
                    xPathFragment.setNamespaceURI(string5);
                    String string6 = ((XMLDescriptor)databaseMapping.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(string5);
                    if (string6 != null && !string6.equals("")) {
                        string4 = string6 + ":" + string4;
                    }
                }
                xPathFragment.setXPath(string4);
                xMLDescriptor = xMLContext.getDescriptorByGlobalType(xPathFragment);
            }
        }
        if (xMLDescriptor == null) {
            throw XMLMarshalException.noDescriptorFound(databaseMapping);
        }
        return xMLDescriptor;
    }

    protected void addTypeAttribute(XMLDescriptor xMLDescriptor, MarshalRecord marshalRecord, String string) {
        String string2 = string.substring(1);
        String string3 = null;
        if (xMLDescriptor.getNamespaceResolver() != null) {
            string3 = xMLDescriptor.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            string3 = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string3, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (string3 == null) {
            string3 = xMLDescriptor.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string3, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", string3 + ":" + "type", string2);
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String string) {
        String string2 = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            string2 = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            string2 = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (string2 == null) {
            string2 = marshalRecord.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", string2 + ":" + "type", string);
    }

    protected void writeExtraNamespaces(List list, XMLRecord xMLRecord, AbstractSession abstractSession) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            ((MarshalRecord)xMLRecord).attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }
}

