/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.osgi;

import java.util.Hashtable;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiPersistenceInitializationHelper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static BundleContext context;
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    public static final String ECLIPSELINK_OSGI_PROVIDER = "org.eclipse.persistence.jpa.osgi.PersistenceProviderOSGi";

    public void bundleChanged(BundleEvent bundleEvent) {
        switch (bundleEvent.getType()) {
            case 128: {
                this.registerBundle(bundleEvent.getBundle());
                break;
            }
            case 256: {
                this.deregisterBundle(bundleEvent.getBundle());
            }
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String string = null;
        ServiceReference serviceReference = bundleContext.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(serviceReference);
        Bundle[] bundleArray = packageAdmin.getFragments(bundleContext.getBundle());
        if (bundleArray != null) {
            for (int i = 0; i < bundleArray.length; ++i) {
                Bundle bundle = bundleArray[i];
                string = (String)bundle.getHeaders().get("JPA-Initializer");
                if (string == null) continue;
                AbstractSessionLog.getLog().log(4, LoggingLocalization.buildMessage("osgi_initializer", new Object[]{string}));
                break;
            }
        }
        this.registerBundleListener();
        this.registerProviderService(string);
    }

    private void registerBundleListener() {
        Activator.getContext().addBundleListener((BundleListener)this);
        Bundle[] bundleArray = Activator.getContext().getBundles();
        for (int i = 0; i < bundleArray.length; ++i) {
            Bundle bundle = bundleArray[i];
            this.registerBundle(bundle);
        }
    }

    private void registerBundle(Bundle bundle) {
        if ((bundle.getState() & 0x2C) != 0 && !OSGiPersistenceInitializationHelper.includesBundle(bundle)) {
            try {
                String[] stringArray = this.getPersistenceUnitNames(bundle);
                if (stringArray != null) {
                    OSGiPersistenceInitializationHelper.addBundle(bundle, stringArray);
                }
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().logThrowable(6, exception);
            }
        }
    }

    private String[] getPersistenceUnitNames(Bundle bundle) {
        String string = (String)bundle.getHeaders().get("JPA-PersistenceUnits");
        if (string != null) {
            return string.split(",");
        }
        return null;
    }

    private void deregisterBundle(Bundle bundle) {
        OSGiPersistenceInitializationHelper.removeBundle(bundle);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Activator.getContext().removeBundleListener((BundleListener)this);
    }

    public static BundleContext getContext() {
        return context;
    }

    public void registerProviderService(String string) throws Exception {
        PersistenceProvider persistenceProvider = new PersistenceProvider(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(PERSISTENCE_PROVIDER, ECLIPSELINK_OSGI_PROVIDER);
        Activator.getContext().registerService(PERSISTENCE_PROVIDER, (Object)persistenceProvider, hashtable);
    }
}

