/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class UnidirectionalOneToManyMapping
extends OneToManyMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient DataModifyQuery preDeleteQuery;
    protected transient boolean hasCustomPreDeleteQuery;
    protected transient DataModifyQuery addTargetQuery = new DataModifyQuery();
    protected transient boolean hasCustomAddTargetQuery;
    protected transient DataModifyQuery removeTargetQuery = new DataModifyQuery();
    protected transient boolean hasCustomRemoveTargetQuery;
    protected transient DataModifyQuery removeAllTargetsQuery = new DataModifyQuery();
    protected transient boolean hasCustomRemoveAllTargetsQuery;
    protected transient boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget = true;
    protected transient boolean shouldIncrementTargetLockValueOnDeleteSource = true;

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        ChangeRecord changeRecord = super.compareForChange(object, object2, objectChangeSet, abstractSession);
        if (changeRecord != null && this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            this.postCalculateChanges(changeRecord, abstractSession);
        }
        return changeRecord;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        Vector<Object> vector = new Vector<Object>(n);
        ConversionManager conversionManager = abstractSession.getDatasourcePlatform().getConversionManager();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = conversionManager.convertObject(object, databaseField.getType());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractSourceKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        Vector<Object> vector = new Vector<Object>(n);
        ConversionManager conversionManager = abstractSession.getDatasourcePlatform().getConversionManager();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.targetForeignKeyFields.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.sourceKeyFields.get(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = conversionManager.convertObject(object, databaseField2.getType());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable<CacheKey, Object> hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                ComplexQueryResult complexQueryResult = (ComplexQueryResult)abstractSession.executeQuery((DatabaseQuery)readAllQuery, abstractRecord2);
                List list = (List)complexQueryResult.getResult();
                hashtable = new Hashtable<CacheKey, Object>();
                List list2 = (List)complexQueryResult.getData();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    CacheKey cacheKey = new CacheKey(this.extractSourceKeyFromRow((AbstractRecord)list2.get(i), abstractSession));
                    if (!hashtable.containsKey(cacheKey)) {
                        hashtable.put(cacheKey, this.containerPolicy.containerInstance());
                    }
                    this.containerPolicy.addInto(e, hashtable.get(cacheKey), abstractSession);
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return this.containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    public boolean isUnidirectionalOneToManyMapping() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.initializeAddTargetQuery(abstractSession);
        this.initializeRemoveTargetQuery(abstractSession);
        this.initializeRemoveAllTargetsQuery(abstractSession);
        if (this.getReferenceDescriptor().getOptimisticLockingPolicy() != null) {
            if (this.shouldIncrementTargetLockValueOnAddOrRemoveTarget) {
                this.descriptor.addMappingsPostCalculateChanges(this);
            }
            if (this.shouldIncrementTargetLockValueOnDeleteSource && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChangesOnDeleted(this);
            }
        }
    }

    public void postInitialize(AbstractSession abstractSession) {
        super.postInitialize(abstractSession);
        Iterator<DatabaseField> iterator = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> iterator2 = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            DatabaseField databaseField2 = iterator2.next();
            if (databaseField.getType() != null) continue;
            databaseField.setType(this.getDescriptor().getObjectBuilder().getMappingForField(databaseField2).getFieldClassification(databaseField2));
        }
    }

    protected void initializeAddTargetQuery(AbstractSession abstractSession) {
        Cloneable cloneable;
        if (!this.addTargetQuery.hasSessionName()) {
            this.addTargetQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomAddTargetQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            cloneable = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = cloneable.and(expression);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            cloneable = (DatabaseField)this.targetForeignKeyFields.get(i);
            databaseRecord.put((DatabaseField)cloneable, (Object)null);
        }
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.addTargetQuery.setSQLStatement(sQLUpdateStatement);
    }

    protected void initializeRemoveTargetQuery(AbstractSession abstractSession) {
        Cloneable cloneable;
        if (!this.removeTargetQuery.hasSessionName()) {
            this.removeTargetQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomRemoveTargetQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = list.get(i);
            cloneable = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = cloneable.and(expression);
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            cloneable = (DatabaseField)this.targetForeignKeyFields.get(i);
            databaseRecord.put((DatabaseField)cloneable, (Object)null);
            Expression expression2 = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression = expression2.and(expression);
        }
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.removeTargetQuery.setSQLStatement(sQLUpdateStatement);
    }

    protected void initializeRemoveAllTargetsQuery(AbstractSession abstractSession) {
        if (!this.removeAllTargetsQuery.hasSessionName()) {
            this.removeAllTargetsQuery.setSessionName(abstractSession.getName());
        }
        if (this.hasCustomRemoveAllTargetsQuery) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.targetForeignKeyFields.get(i);
            databaseRecord.put(databaseField, (Object)null);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField));
            expression = expression2.and(expression);
        }
        SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
        sQLUpdateStatement.setTable(this.getReferenceDescriptor().getDefaultTable());
        sQLUpdateStatement.setWhereClause(expression);
        sQLUpdateStatement.setModifyRow(databaseRecord);
        this.removeAllTargetsQuery.setSQLStatement(sQLUpdateStatement);
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(objectLevelModifyQuery, object, objectChangeSet);
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{ObjectAdded, objectLevelModifyQuery, object};
            objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded(objectLevelModifyQuery, object);
        }
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (!this.isPrivateOwned()) {
            if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
                Object[] objectArray = new Object[]{ObjectRemoved, objectLevelModifyQuery, object};
                objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            } else {
                this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved(objectLevelModifyQuery, object);
            }
        }
        super.objectRemovedDuringUpdate(objectLevelModifyQuery, object);
    }

    public void performDataModificationEvent(Object[] objectArray, AbstractSession abstractSession) throws DatabaseException, DescriptorException {
        if (objectArray[0] == PostInsert) {
            this.updateTargetForeignKeysPostInsertSource((WriteObjectQuery)objectArray[1]);
        } else if (objectArray[0] == ObjectRemoved) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectRemoved((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else if (objectArray[0] == ObjectAdded) {
            this.updateTargetForeignKeyPostUpdateSource_ObjectAdded((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            super.preDelete(deleteObjectQuery);
        } else {
            this.updateTargetForeignKeyPreDeleteSource(deleteObjectQuery);
        }
    }

    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        cascadeLockingPolicy.setShouldHandleUnmappedFields(true);
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, AbstractSession abstractSession) {
        CollectionChangeRecord collectionChangeRecord = (CollectionChangeRecord)changeRecord;
        for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getAddObjectList().values()) {
            if (objectChangeSet.hasChanges()) continue;
            objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
            ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, abstractSession, false);
        }
        if (!this.isPrivateOwned()) {
            for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getRemoveObjectList().values()) {
                if (objectChangeSet.hasChanges()) continue;
                objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, abstractSession, false);
            }
        }
    }

    public void postCalculateChangesOnDeleted(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
        Object object2 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        if (object2 != null) {
            Object object3 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object3)) {
                Object object4 = this.containerPolicy.next(object3, abstractSession);
                ObjectChangeSet objectChangeSet = this.referenceDescriptor.getObjectBuilder().createObjectChangeSet(object4, unitOfWorkChangeSet, abstractSession);
                if (objectChangeSet.hasChanges()) continue;
                objectChangeSet.setShouldModifyVersionField(Boolean.TRUE);
                ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).addObjectChangeSet(objectChangeSet, abstractSession, false);
            }
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        super.postInsert(writeObjectQuery);
        if (this.isReadOnly()) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{PostInsert, writeObjectQuery};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.updateTargetForeignKeysPostInsertSource(writeObjectQuery);
        }
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readQuery;
        readAllQuery2.setShouldIncludeData(true);
        int n = this.targetForeignKeyFields.size();
        for (int i = 0; i < n; ++i) {
            readAllQuery2.addAdditionalField((DatabaseField)this.targetForeignKeyFields.get(i));
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    protected void prepareTranslationRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        int n = this.sourceKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            if (abstractRecord.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            abstractRecord.put(databaseField, object2);
        }
    }

    public void setAddTargetSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomAddTargetQuery(dataModifyQuery);
    }

    public void setCustomAddTargetQuery(DataModifyQuery dataModifyQuery) {
        this.addTargetQuery = dataModifyQuery;
        this.hasCustomAddTargetQuery = true;
    }

    public void setCustomRemoveTargetQuery(DataModifyQuery dataModifyQuery) {
        this.removeTargetQuery = dataModifyQuery;
        this.hasCustomRemoveTargetQuery = true;
    }

    public void setCustomRemoveAllTargetsQuery(DataModifyQuery dataModifyQuery) {
        this.removeAllTargetsQuery = dataModifyQuery;
        this.hasCustomRemoveAllTargetsQuery = true;
    }

    public void setSessionName(String string) {
        super.setSessionName(string);
        this.addTargetQuery.setSessionName(string);
        this.removeTargetQuery.setSessionName(string);
        this.removeAllTargetsQuery.setSessionName(string);
    }

    public void setShouldIncrementTargetLockValueOnAddOrRemoveTarget(boolean bl) {
        this.shouldIncrementTargetLockValueOnAddOrRemoveTarget = bl;
    }

    public void setShouldIncrementTargetLockValueOnDeleteSource(boolean bl) {
        this.shouldIncrementTargetLockValueOnDeleteSource = bl;
    }

    public boolean shouldIncrementTargetLockValueOnAddOrRemoveTarget() {
        return this.shouldIncrementTargetLockValueOnAddOrRemoveTarget;
    }

    public boolean shouldIncrementTargetLockValueOnDeleteSource() {
        return this.shouldIncrementTargetLockValueOnDeleteSource;
    }

    public void updateTargetForeignKeysPostInsertSource(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object3 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession()))) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.sourceKeyFields.size();
        for (int i = 0; i < n; ++i) {
            object2 = (DatabaseField)this.sourceKeyFields.get(i);
            object = (DatabaseField)this.targetForeignKeyFields.get(i);
            Object object4 = writeObjectQuery.getTranslationRow().get((DatabaseField)object2);
            databaseRecord.put((DatabaseField)object, object4);
        }
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        n = list.size();
        object2 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object2)) {
            object = containerPolicy.next(object2, writeObjectQuery.getSession());
            for (int i = 0; i < n; ++i) {
                DatabaseField databaseField = list.get(i);
                Object object5 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, writeObjectQuery.getSession());
                databaseRecord.put(databaseField, object5);
            }
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRecord);
        }
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectAdded(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException {
        Object object2;
        DatabaseField databaseField;
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.sourceKeyFields.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField2 = (DatabaseField)this.sourceKeyFields.get(i);
            databaseField = (DatabaseField)this.targetForeignKeyFields.get(i);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField2);
            databaseRecord.put(databaseField, object2);
        }
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        n = list.size();
        for (int i = 0; i < n; ++i) {
            databaseField = list.get(i);
            object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, objectLevelModifyQuery.getSession());
            databaseRecord.put(databaseField, object2);
        }
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.addTargetQuery, databaseRecord);
    }

    public void updateTargetForeignKeyPostUpdateSource_ObjectRemoved(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException {
        Object object2;
        DatabaseField databaseField;
        if (this.isReadOnly) {
            return;
        }
        AbstractSession abstractSession = objectLevelModifyQuery.getSession();
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), abstractSession);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        int n = this.sourceKeyFields.size();
        DatabaseRecord databaseRecord2 = new DatabaseRecord(n);
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField2 = (DatabaseField)this.sourceKeyFields.get(i);
            databaseField = (DatabaseField)this.targetForeignKeyFields.get(i);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField2);
            databaseRecord.add(databaseField, object2);
            databaseRecord2.add(databaseField, null);
        }
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        n = list.size();
        for (int i = 0; i < n; ++i) {
            databaseField = list.get(i);
            object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            databaseRecord.add(databaseField, object2);
        }
        DataModifyQuery dataModifyQuery = (DataModifyQuery)this.removeTargetQuery.clone();
        dataModifyQuery.setModifyRow(databaseRecord2);
        dataModifyQuery.setHasModifyRow(true);
        dataModifyQuery.setIsExecutionClone(true);
        abstractSession.executeQuery((DatabaseQuery)dataModifyQuery, databaseRecord);
    }

    public void updateTargetForeignKeyPreDeleteSource(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        int n = this.sourceKeyFields.size();
        DatabaseRecord databaseRecord = new DatabaseRecord(n);
        DatabaseRecord databaseRecord2 = new DatabaseRecord(n);
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)this.sourceKeyFields.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.targetForeignKeyFields.get(i);
            Object object = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.add(databaseField2, object);
            databaseRecord2.add(databaseField2, null);
        }
        DataModifyQuery dataModifyQuery = (DataModifyQuery)this.removeAllTargetsQuery.clone();
        dataModifyQuery.setModifyRow(databaseRecord2);
        dataModifyQuery.setHasModifyRow(true);
        dataModifyQuery.setIsExecutionClone(true);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)dataModifyQuery, databaseRecord);
    }
}

