/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.querykeys;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public class ForeignReferenceQueryKey
extends QueryKey {
    protected Class referenceClass;
    protected String referenceClassName;
    protected Expression joinCriteria;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz = null;
        try {
            if (this.referenceClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.referenceClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, privilegedActionException.getException());
                    }
                } else {
                    clazz = PrivilegedAccessHelper.getClassForName(this.referenceClassName, true, classLoader);
                }
            }
            this.setReferenceClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.referenceClassName, classNotFoundException);
        }
    }

    public Expression getJoinCriteria() {
        return this.joinCriteria;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean isForeignReferenceQueryKey() {
        return true;
    }

    public void setJoinCriteria(Expression expression) {
        this.joinCriteria = expression;
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    public DatabaseTable getSourceTable() {
        return this.descriptor.getTables().firstElement();
    }

    public DatabaseTable getReferenceTable(ClassDescriptor classDescriptor) {
        return classDescriptor.getTables().firstElement();
    }
}

