/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDODataFactory;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;

public class SDODataFactoryDelegate
implements SDODataFactory {
    private HelperContext aHelperContext;

    public SDODataFactoryDelegate(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public DataObject create(String string, String string2) {
        Type type = this.getHelperContext().getTypeHelper().getType(string, string2);
        if (type != null) {
            return this.create(type);
        }
        throw new IllegalArgumentException(SDOException.typeNotFound(string, string2));
    }

    public DataObject create(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(SDOException.typeNotFoundForInterface(null));
        }
        Type type = this.getHelperContext().getTypeHelper().getType(clazz);
        if (type != null && type.getInstanceClass() != null) {
            return this.create(type);
        }
        throw new IllegalArgumentException(SDOException.typeNotFoundForInterface(clazz.getName()));
    }

    public DataObject create(Type type) {
        Object object;
        Object object2;
        if (type.isAbstract()) {
            throw new IllegalArgumentException(SDOException.errorCreatingDataObjectForType(type.getURI(), type.getName()));
        }
        if (type.isDataType()) {
            object2 = (SDOTypeHelper)this.getHelperContext().getTypeHelper();
            type = (SDOType)object2.getWrappersHashMap().get(((SDOType)type).getQName());
        }
        if ((object2 = ((SDOType)type).getInstanceClass()) != null) {
            try {
                object = ((SDOType)type).getImplClass();
                if (object != null) {
                    SDODataObject sDODataObject = (SDODataObject)((Class)object).newInstance();
                    sDODataObject._setType(type);
                    sDODataObject._setHelperContext(this.getHelperContext());
                    return sDODataObject;
                }
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException(SDOException.errorCreatingDataObjectForClass(instantiationException, ((Class)object2).getName(), type.getURI(), type.getName()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(SDOException.errorCreatingDataObjectForClass(illegalAccessException, ((Class)object2).getName(), type.getURI(), type.getName()));
            }
        }
        object = new SDODataObject();
        ((SDODataObject)object)._setType(type);
        ((SDODataObject)object)._setHelperContext(this.getHelperContext());
        return object;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

