/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.ExclusiveIsolatedClientSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.Server;

public class ServerSession
extends DatabaseSessionImpl
implements Server {
    protected ConnectionPool readConnectionPool;
    protected Map connectionPools = new HashMap(10);
    protected ConnectionPolicy defaultConnectionPolicy;
    protected int maxNumberOfNonPooledConnections;
    public static final int NO_MAX = -1;
    protected int numberOfNonPooledConnectionsUsed;
    public static final int MAX_WRITE_CONNECTIONS = 10;
    public static final int MIN_WRITE_CONNECTIONS = 5;

    public ServerSession() {
    }

    public ServerSession(Login login) {
        this(new Project(login));
    }

    public ServerSession(Login login, int n, int n2) {
        this(new Project(login), n, n2);
    }

    public ServerSession(Login login, ConnectionPolicy connectionPolicy) {
        this(new Project(login), connectionPolicy);
    }

    public ServerSession(Project project) {
        this(project, 5, 10);
    }

    public ServerSession(Project project, int n, int n2) {
        this(project, new ConnectionPolicy("default"));
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, int n, int n2, Login login) {
        this(project, new ConnectionPolicy("default"), login);
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, int n, int n2, Login login, Login login2) {
        this(project, new ConnectionPolicy("default"), login, login2);
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy) {
        super(project);
        this.defaultConnectionPolicy = connectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        this.setReadConnectionPool(project.getDatasourceLogin());
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy, Login login) {
        super(project);
        this.defaultConnectionPolicy = connectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        Login login2 = login != null ? login : project.getDatasourceLogin();
        this.setReadConnectionPool(login2);
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy, Login login, Login login2) {
        this(project, connectionPolicy, login);
        if (login2 != null) {
            this.getSequencingControl().setShouldUseSeparateConnection(true);
            this.getSequencingControl().setLogin(login2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireClientConnection(ClientSession clientSession) throws DatabaseException, ConcurrencyException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool connectionPool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            Accessor accessor = connectionPool.acquireConnection();
            clientSession.setWriteConnection(accessor);
            if (!accessor.usesExternalConnectionPooling()) {
                clientSession.getEventManager().postAcquireConnection(accessor);
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().postAcquireExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
        } else {
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession serverSession = this;
                synchronized (serverSession) {
                    while (this.numberOfNonPooledConnectionsUsed >= this.maxNumberOfNonPooledConnections) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw ConcurrencyException.waitFailureOnServerSession(interruptedException);
                        }
                    }
                    ++this.numberOfNonPooledConnectionsUsed;
                }
            }
            clientSession.setWriteConnection(clientSession.getLogin().buildAccessor());
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.connect();
                clientSession.getEventManager().postAcquireConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().postAcquireExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
        }
    }

    public ClientSession acquireClientSession() throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy());
    }

    public ClientSession acquireClientSession(Map map) throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy(), map);
    }

    public ClientSession acquireClientSession(String string) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(string));
    }

    public ClientSession acquireClientSession(String string, Map map) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(string), map);
    }

    public ClientSession acquireClientSession(Login login) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login));
    }

    public ClientSession acquireClientSession(Login login, Map map) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login), map);
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy) throws DatabaseException, ValidationException {
        return this.acquireClientSession(connectionPolicy, null);
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy, Map map) throws DatabaseException, ValidationException {
        Object object;
        if (!this.isConnected()) {
            throw ValidationException.loginBeforeAllocatingClientSessions();
        }
        this.log(2, "connection", "client_acquired");
        if (!connectionPolicy.isPooled() && connectionPolicy.getLogin() == null) {
            connectionPolicy.setPoolName(this.getDefaultConnectionPolicy().getPoolName());
            connectionPolicy.setLogin(this.getDefaultConnectionPolicy().getLogin());
        }
        if (connectionPolicy.isPooled()) {
            object = (ConnectionPool)this.getConnectionPools().get(connectionPolicy.getPoolName());
            if (object == null) {
                throw ValidationException.poolNameDoesNotExist(connectionPolicy.getPoolName());
            }
            connectionPolicy.setLogin(((ConnectionPool)object).getLogin());
        }
        object = null;
        if (this.getProject().hasIsolatedClasses()) {
            object = connectionPolicy.isExclusive() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, map) : new IsolatedClientSession(this, connectionPolicy, map);
        } else {
            if (connectionPolicy.isExclusiveIsolated()) {
                throw ValidationException.clientSessionCanNotUseExclusiveConnection();
            }
            object = connectionPolicy.isExclusiveAlways() ? new ExclusiveIsolatedClientSession(this, connectionPolicy, map) : new ClientSession(this, connectionPolicy, map);
        }
        if (this.isFinalizersEnabled()) {
            ((AbstractSession)object).registerFinalizer();
        }
        if (!connectionPolicy.isLazy()) {
            this.acquireClientConnection((ClientSession)object);
        }
        return object;
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireClientSession().acquireUnitOfWork();
    }

    public void addConnectionPool(String string, Login login, int n, int n2) throws ValidationException {
        if (n > n2) {
            throw ValidationException.maxSizeLessThanMinSize();
        }
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool connectionPool = null;
        connectionPool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(string, login, this) : new ConnectionPool(string, login, n, n2, this);
        this.addConnectionPool(connectionPool);
    }

    public void addConnectionPool(ConnectionPool connectionPool) {
        connectionPool.setOwner(this);
        this.getConnectionPools().put(connectionPool.getName(), connectionPool);
    }

    public Accessor allocateReadConnection() {
        Accessor accessor = this.getReadConnectionPool().acquireConnection();
        if (!accessor.usesExternalConnectionPooling()) {
            this.getEventManager().postAcquireConnection(accessor);
        }
        return accessor;
    }

    public void connect() {
        this.updateStandardConnectionPools();
        this.getReadConnectionPool().startUp();
        this.setAccessor(this.allocateReadConnection());
        this.releaseReadConnection(this.getAccessor());
        Iterator iterator = this.getConnectionPools().values().iterator();
        while (iterator.hasNext()) {
            ((ConnectionPool)iterator.next()).startUp();
        }
    }

    public void disconnect() throws DatabaseException {
        try {
            super.disconnect();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord abstractRecord, DatabaseQuery databaseQuery) throws DatabaseException {
        Object object;
        block14: {
            RuntimeException runtimeException = null;
            object = null;
            boolean bl = false;
            if (databaseQuery.getAccessor() == null) {
                databaseQuery.setAccessor(this.allocateReadConnection());
                bl = true;
            }
            try {
                object = databaseQuery.getAccessor().executeCall(call, abstractRecord, this);
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                return runtimeException;
            }
            finally {
                block15: {
                    if (call.isFinished() || runtimeException != null) {
                        try {
                            if (bl) {
                                this.releaseReadConnection(databaseQuery.getAccessor());
                                databaseQuery.setAccessor(null);
                            }
                        }
                        catch (RuntimeException runtimeException3) {
                            if (runtimeException != null) break block15;
                            throw runtimeException3;
                        }
                    }
                }
                if (runtimeException == null) break block14;
                throw runtimeException;
            }
        }
        return object;
    }

    public ConnectionPool getConnectionPool(String string) {
        return (ConnectionPool)this.getConnectionPools().get(string);
    }

    public Map getConnectionPools() {
        return this.connectionPools;
    }

    public ConnectionPolicy getDefaultConnectionPolicy() {
        if (this.defaultConnectionPolicy == null) {
            this.defaultConnectionPolicy = new ConnectionPolicy("default");
        }
        return this.defaultConnectionPolicy;
    }

    public ConnectionPool getDefaultConnectionPool() {
        return this.getConnectionPool("default");
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        if (databaseQuery.isObjectLevelModifyQuery()) {
            throw QueryException.invalidQueryOnServerSession(databaseQuery);
        }
        return this;
    }

    public int getMaxNumberOfNonPooledConnections() {
        return this.maxNumberOfNonPooledConnections;
    }

    public int getNumberOfNonPooledConnectionsUsed() {
        return this.numberOfNonPooledConnectionsUsed;
    }

    protected Login getReadLogin() {
        return this.getReadConnectionPool().getLogin();
    }

    public ConnectionPool getReadConnectionPool() {
        return this.readConnectionPool;
    }

    public boolean isConnected() {
        if (this.getReadConnectionPool() == null) {
            return false;
        }
        return this.getReadConnectionPool().isConnected();
    }

    public boolean isServerSession() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        try {
            super.logout();
        }
        finally {
            this.getReadConnectionPool().shutDown();
            Iterator iterator = this.getConnectionPools().values().iterator();
            while (iterator.hasNext()) {
                ((ConnectionPool)iterator.next()).shutDown();
            }
        }
    }

    public void postConnectExternalConnection(Accessor accessor) {
        this.getEventManager().postAcquireConnection(accessor);
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        this.getEventManager().preReleaseConnection(accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClientSession(ClientSession clientSession) throws DatabaseException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool connectionPool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().preReleaseExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
            }
            connectionPool.releaseConnection(clientSession.getWriteConnection());
            clientSession.setWriteConnection(null);
        } else {
            if (!clientSession.getWriteConnection().usesExternalConnectionPooling()) {
                clientSession.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
                if (clientSession.isExclusiveIsolatedClientSession()) {
                    this.getEventManager().preReleaseExclusiveConnection(clientSession, clientSession.getWriteConnection());
                }
                clientSession.disconnect();
            } else {
                clientSession.getWriteConnection().closeConnection();
            }
            clientSession.setWriteConnection(null);
            if (this.maxNumberOfNonPooledConnections != -1) {
                ServerSession serverSession = this;
                synchronized (serverSession) {
                    --this.numberOfNonPooledConnectionsUsed;
                    this.notify();
                }
            }
        }
    }

    public void releaseReadConnection(Accessor accessor) {
        if (!accessor.usesExternalConnectionPooling()) {
            this.getEventManager().preReleaseConnection(accessor);
        }
        this.getReadConnectionPool().releaseConnection(accessor);
    }

    public void setCheckConnections() {
        this.getReadConnectionPool().setCheckConnections();
        Object object = this.getConnectionPools().values().iterator();
        while (object.hasNext()) {
            ((ConnectionPool)object.next()).setCheckConnections();
        }
        object = this.getSequencingServer().getConnectionPool();
        if (object != null) {
            ((ConnectionPool)object).setCheckConnections();
        }
    }

    public void setConnectionPools(Map map) {
        this.connectionPools = map;
    }

    public void setDefaultConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.defaultConnectionPolicy = connectionPolicy;
    }

    public void setDefaultConnectionPool() {
        this.addConnectionPool("default", this.getDatasourceLogin(), 5, 10);
    }

    public void setMaxNumberOfNonPooledConnections(int n) {
        this.maxNumberOfNonPooledConnections = n;
    }

    public void setNumberOfNonPooledConnectionsUsed(int n) {
        this.numberOfNonPooledConnectionsUsed = n;
    }

    public void setReadConnectionPool(ConnectionPool connectionPool) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.readConnectionPool = connectionPool;
        this.readConnectionPool.setOwner(this);
    }

    public void setReadConnectionPool(Login login) throws ValidationException {
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool connectionPool = null;
        connectionPool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("read", login, this) : new ConnectionPool("read", login, 2, 2, this);
        this.readConnectionPool = connectionPool;
    }

    public void setSynchronized(boolean bl) {
    }

    protected void updateStandardConnectionPools() {
        if (this.getDefaultConnectionPool() != null && this.getDefaultConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setDefaultConnectionPool();
        }
        if (this.getReadConnectionPool() != null && this.getReadConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setReadConnectionPool(this.getReadConnectionPool().getLogin());
        }
    }

    public void useExclusiveReadConnectionPool(int n, int n2) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), n, n2, this));
    }

    public void useExternalReadConnectionPool() {
        this.setReadConnectionPool(new ExternalConnectionPool("read", this.getDatasourceLogin(), this));
    }

    public void useReadConnectionPool(int n, int n2) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), n, n2, this));
    }

    public void validateQuery(DatabaseQuery databaseQuery) {
        if (databaseQuery.isObjectLevelReadQuery() && (databaseQuery.getDescriptor().isIsolated() || ((ObjectLevelReadQuery)databaseQuery).shouldUseExclusiveConnection())) {
            throw QueryException.isolatedQueryExecutedOnServerSession();
        }
    }

    public SequencingServer getSequencingServer() {
        return this.getSequencingHome().getSequencingServer();
    }
}

