/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPAttachmentHandler;
import org.eclipse.persistence.internal.dbws.SOAPResponse;
import org.eclipse.persistence.internal.dbws.SOAPResponseClassLoader;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.w3c.dom.Node;

public class SOAPResponseWriter {
    protected DBWSAdapter dbwsAdapter;
    protected Map<String, XMLDescriptor> resultDescriptors = new HashMap<String, XMLDescriptor>();
    protected MessageFactory messageFactory;

    public SOAPResponseWriter(DBWSAdapter dBWSAdapter) {
        this.dbwsAdapter = dBWSAdapter;
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
    }

    public void initialize() {
        SOAPResponseClassLoader sOAPResponseClassLoader = new SOAPResponseClassLoader(Thread.currentThread().getContextClassLoader());
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("srvc", this.dbwsAdapter.getExtendedSchema().getTargetNamespace());
        for (Operation operation : this.dbwsAdapter.getOperationsList()) {
            String string = operation.getName() + "_Response";
            Class<?> clazz = sOAPResponseClassLoader.buildClass(string);
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setDefaultRootElement("srvc:" + operation.getName() + "Response");
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            xMLDescriptor.setJavaClass(clazz);
            if (operation instanceof QueryOperation) {
                String string2;
                Object object;
                QueryOperation queryOperation = (QueryOperation)operation;
                if (queryOperation.isSimpleXMLFormat()) {
                    object = new XMLAnyObjectMapping();
                    object.setUseXMLRoot(true);
                    object.setAttributeName("result");
                    object.setXPath("srvc:result");
                    xMLDescriptor.addMapping((DatabaseMapping)object);
                    object.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                } else if (queryOperation.isAttachment()) {
                    object = queryOperation.getResult().getAttachment();
                    string2 = new XMLBinaryDataMapping();
                    string2.setAttributeName("result");
                    string2.setXPath("srvc:result");
                    string2.setSwaRef(true);
                    string2.setShouldInlineBinaryData(false);
                    string2.setMimeType(((Attachment)object).getMimeType());
                    xMLDescriptor.addMapping((DatabaseMapping)string2);
                } else {
                    XMLCompositeCollectionMapping xMLCompositeCollectionMapping;
                    object = queryOperation.getResult().getType();
                    string2 = ((QName)object).getLocalPart();
                    Set set = this.dbwsAdapter.getSchema().getTopLevelComplexTypes().entrySet();
                    XMLDescriptor xMLDescriptor2 = set.iterator();
                    while (xMLDescriptor2.hasNext()) {
                        xMLCompositeCollectionMapping = xMLDescriptor2.next();
                        if (!((ComplexType)xMLCompositeCollectionMapping.getValue()).getName().equals(((QName)object).getLocalPart())) continue;
                        string2 = (String)xMLCompositeCollectionMapping.getKey();
                        break;
                    }
                    if ((xMLDescriptor2 = this.dbwsAdapter.getDescriptorsByQName().get(object)) != null) {
                        if (queryOperation.isCollection()) {
                            xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
                            xMLCompositeCollectionMapping.setAttributeName("result");
                            xMLCompositeCollectionMapping.setReferenceClass(xMLDescriptor2.getJavaClass());
                            xMLCompositeCollectionMapping.useCollectionClass(ArrayList.class);
                            xMLCompositeCollectionMapping.setXPath("srvc:result/" + string2);
                            xMLDescriptor.getNamespaceResolver().setDefaultNamespaceURI(xMLDescriptor2.getNamespaceResolver().getDefaultNamespaceURI());
                            xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
                            xMLCompositeCollectionMapping.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        } else {
                            xMLCompositeCollectionMapping = new XMLCompositeObjectMapping();
                            xMLCompositeCollectionMapping.setAttributeName("result");
                            xMLCompositeCollectionMapping.setReferenceClass(xMLDescriptor2.getJavaClass());
                            xMLCompositeCollectionMapping.setXPath("srvc:result/" + string2);
                            xMLDescriptor.getNamespaceResolver().setDefaultNamespaceURI(xMLDescriptor2.getNamespaceResolver().getDefaultNamespaceURI());
                            xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
                            xMLCompositeCollectionMapping.initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        }
                    } else if (((QName)object).equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                        xMLCompositeCollectionMapping = new XMLAnyObjectMapping();
                        xMLCompositeCollectionMapping.setAttributeName("result");
                        xMLCompositeCollectionMapping.setXPath("srvc:result");
                        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
                    } else if (((QName)object).equals(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))) {
                        xMLCompositeCollectionMapping = new XMLBinaryDataMapping();
                        xMLCompositeCollectionMapping.setAttributeName("result");
                        xMLCompositeCollectionMapping.setXPath("srvc:result");
                        xMLCompositeCollectionMapping.setShouldInlineBinaryData(true);
                        ((XMLField)xMLCompositeCollectionMapping.getField()).setSchemaType((QName)object);
                        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
                    } else {
                        xMLCompositeCollectionMapping = new XMLDirectMapping();
                        xMLCompositeCollectionMapping.setAttributeName("result");
                        xMLCompositeCollectionMapping.setXPath("srvc:result/text()");
                        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
                    }
                }
            }
            this.dbwsAdapter.getOXSession().getProject().addDescriptor((ClassDescriptor)xMLDescriptor);
            ((DatabaseSessionImpl)this.dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive((ClassDescriptor)xMLDescriptor);
            this.dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
            this.resultDescriptors.put(operation.getName(), xMLDescriptor);
        }
    }

    public SOAPMessage generateResponse(Operation operation, EclipseLinkException eclipseLinkException) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        sOAPBody.addFault(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), operation.getName() + " failed: " + eclipseLinkException.getMessage());
        return sOAPMessage;
    }

    public SOAPMessage generateResponse(Operation operation, Object object) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        XMLDescriptor xMLDescriptor = this.resultDescriptors.get(operation.getName());
        SOAPResponse sOAPResponse = null;
        try {
            sOAPResponse = (SOAPResponse)xMLDescriptor.getJavaClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new SOAPException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SOAPException((Throwable)illegalAccessException);
        }
        sOAPResponse.setResult(object);
        SOAPAttachmentHandler sOAPAttachmentHandler = new SOAPAttachmentHandler();
        XMLMarshaller xMLMarshaller = this.dbwsAdapter.getXMLContext().createMarshaller();
        xMLMarshaller.setAttachmentMarshaller((XMLAttachmentMarshaller)sOAPAttachmentHandler);
        xMLMarshaller.marshal((Object)sOAPResponse, (Node)sOAPBody);
        if (sOAPAttachmentHandler.hasAttachments()) {
            for (String string : sOAPAttachmentHandler.getAttachments().keySet()) {
                DataHandler dataHandler = sOAPAttachmentHandler.getAttachments().get(string);
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(dataHandler);
                attachmentPart.setContentType(dataHandler.getContentType());
                String string2 = "<" + string.substring(4) + ">";
                attachmentPart.setContentId(string2);
                attachmentPart.setMimeHeader("Content-Transfer-Encoding", "binary");
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
        }
        return sOAPMessage;
    }
}

