/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public abstract class QueryHandler {
    protected DatabaseQuery databaseQuery;

    public DatabaseQuery getDatabaseQuery() {
        return this.databaseQuery;
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.databaseQuery = databaseQuery;
    }

    public void validate(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
    }

    public void initialize(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
        this.initializeDatabaseQuery(xRServiceAdapter, queryOperation);
        this.initializeCall(xRServiceAdapter, queryOperation, this.getDatabaseQuery());
        this.initializeArguments(xRServiceAdapter, queryOperation, this.getDatabaseQuery());
    }

    public void initializeDatabaseQuery(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
        Object object;
        if (queryOperation.hasResponse()) {
            QName qName = queryOperation.getResult().getType();
            object = queryOperation.isCollection() ? (queryOperation.isSimpleXMLFormat() ? new DataReadQuery() : (!xRServiceAdapter.descriptorsByQName.containsKey(qName) ? new DataReadQuery() : new ReadAllQuery(xRServiceAdapter.getTypeClass(qName)))) : (queryOperation.isSimpleXMLFormat() ? new DataReadQuery() : (!xRServiceAdapter.descriptorsByQName.containsKey(qName) ? new ValueReadQuery() : new ReadObjectQuery(xRServiceAdapter.getTypeClass(qName))));
        } else {
            object = new DataModifyQuery();
        }
        object.bindAllParameters();
        this.setDatabaseQuery((DatabaseQuery)object);
    }

    public void initializeCall(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
    }

    public void initializeArguments(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        for (int i = 0; i < queryOperation.getParameters().size(); ++i) {
            Object object;
            String string;
            Parameter parameter = queryOperation.getParameters().get(i);
            if (parameter instanceof Parameter && (string = ((Parameter)(object = parameter)).getName()) != null && string.length() > 0) {
                databaseQuery.addArgument(string);
                continue;
            }
            object = Integer.toString(i + 1);
            databaseQuery.addArgument((String)object);
        }
    }
}

