/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.types;

import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOMethodAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sessions.Project;

public class SDOWrapperType
extends SDOType
implements Type {
    private static final List EMPTY_LIST = new ArrayList(0);
    private String typeName;
    private Map<QName, XMLDescriptor> descriptorsMap;

    public SDOWrapperType(Type type, String string, SDOTypeHelper sDOTypeHelper) {
        this(type, string, sDOTypeHelper, (QName)null);
    }

    public SDOWrapperType(Type type, String string, SDOTypeHelper sDOTypeHelper, QName qName) {
        this(type, string, sDOTypeHelper, new QName[]{qName});
    }

    public SDOWrapperType(Type type, String string, SDOTypeHelper sDOTypeHelper, QName[] qNameArray) {
        super("org.eclipse.persistence.sdo", string, sDOTypeHelper);
        this.typeName = string;
        SDOProperty sDOProperty = new SDOProperty(this.aHelperContext);
        sDOProperty.setName("value");
        sDOProperty.setType(type);
        sDOProperty.setXsdType(qNameArray[0]);
        this.addDeclaredProperty(sDOProperty);
        String string2 = SDOUtil.className(string, true, true, false);
        String string3 = "org.eclipse.persistence.sdo." + string2 + "Wrapper";
        this.setInstanceClassName(string3);
        String string4 = "org.eclipse.persistence.sdo." + string2 + "WrapperImpl";
        this.setImplClassName(string4);
        this.getInstanceClass();
        this.getImplClass();
        this.xmlDescriptor.getInterfacePolicy().addParentInterface(this.getInstanceClass());
        this.initializeDescriptor(this.xmlDescriptor, qNameArray[0], type, sDOProperty);
        this.descriptorsMap = new HashMap<QName, XMLDescriptor>();
        this.descriptorsMap.put(qNameArray[0], this.xmlDescriptor);
        this.setSchemaContext(this.xmlDescriptor, qNameArray[0]);
        if (qNameArray.length > 1) {
            for (int i = 1; i < qNameArray.length; ++i) {
                XMLDescriptor xMLDescriptor = new XMLDescriptor();
                QName qName = qNameArray[i];
                String string5 = "org.eclipse.persistence.sdo." + string2 + "_" + qName.getLocalPart() + "Wrapper";
                try {
                    SDOClassLoader sDOClassLoader = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader();
                    xMLDescriptor.setJavaClass(sDOClassLoader.loadClass(string5 + "Impl", this));
                    xMLDescriptor.getInterfacePolicy().addParentInterface(sDOClassLoader.loadClass(string5, this));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw SDOException.classNotFound((Exception)classNotFoundException, (String)this.getURI(), (String)this.getName());
                }
                catch (SecurityException securityException) {
                    throw SDOException.classNotFound((Exception)securityException, (String)this.getURI(), (String)this.getName());
                }
                this.initializeDescriptor(xMLDescriptor, qName, type, sDOProperty);
                this.descriptorsMap.put(qNameArray[i], xMLDescriptor);
                this.setSchemaContext(xMLDescriptor, qNameArray[i]);
            }
        }
    }

    private void setSchemaContext(XMLDescriptor xMLDescriptor, QName qName) {
        if (qName == null || xMLDescriptor == null) {
            return;
        }
        XMLSchemaURLReference xMLSchemaURLReference = new XMLSchemaURLReference();
        xMLSchemaURLReference.setSchemaContextAsQName(qName);
        xMLDescriptor.setSchemaReference((XMLSchemaReference)xMLSchemaURLReference);
    }

    private void initializeDescriptor(XMLDescriptor xMLDescriptor, QName qName, Type type, SDOProperty sDOProperty) {
        xMLDescriptor.setNamespaceResolver(null);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("value");
        xMLDirectMapping.setXPath("text()");
        xMLDirectMapping.setAttributeClassification(type.getInstanceClass());
        ((XMLField)xMLDirectMapping.getField()).setSchemaType(qName);
        SDOMethodAttributeAccessor sDOMethodAttributeAccessor = null;
        sDOMethodAttributeAccessor = new SDOMethodAttributeAccessor(sDOProperty);
        xMLDirectMapping.setAttributeAccessor((AttributeAccessor)sDOMethodAttributeAccessor);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        xMLDescriptor.setIsWrapper(true);
    }

    public XMLDescriptor getXmlDescriptor(QName qName) {
        XMLDescriptor xMLDescriptor = this.descriptorsMap.get(qName);
        if (xMLDescriptor == null) {
            return this.xmlDescriptor;
        }
        return xMLDescriptor;
    }

    public Map getDescriptorsMap() {
        return this.descriptorsMap;
    }

    public void addDescriptorToProject(Project project) {
        Iterator<XMLDescriptor> iterator = this.descriptorsMap.values().iterator();
        while (iterator.hasNext()) {
            project.addDescriptor((ClassDescriptor)iterator.next());
        }
    }

    public List getAliasNames() {
        return EMPTY_LIST;
    }

    public List getBaseTypes() {
        return EMPTY_LIST;
    }

    public String getName() {
        return this.typeName;
    }

    public String getURI() {
        return "org.eclipse.persistence.sdo";
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDataType() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isSequenced() {
        return false;
    }

    public boolean isFinalized() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
        stringBuffer.append("{uri=");
        stringBuffer.append(this.getURI());
        stringBuffer.append(" name=");
        stringBuffer.append(this.getName());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

