/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CacheImpl {
    private IdentityMapAccessor imap;
    private EntityManagerFactoryImpl emf;
    private ServerSession serversession;

    public CacheImpl(EntityManagerFactoryImpl entityManagerFactoryImpl, IdentityMapAccessor identityMapAccessor) {
        this.imap = identityMapAccessor;
        this.emf = entityManagerFactoryImpl;
        this.serversession = entityManagerFactoryImpl.getServerSession();
    }

    public boolean contains(Class clazz, Object object) {
        this.emf.verifyOpen();
        return this.imap.containsObjectInIdentityMap(this.createPKVector(clazz, object), clazz);
    }

    public void evict(Class clazz, Object object) {
        this.emf.verifyOpen();
        this.imap.invalidateObject(this.createPKVector(clazz, object), clazz);
    }

    public void evict(Class clazz) {
        this.emf.verifyOpen();
        this.imap.invalidateClass(clazz);
    }

    public void evictAll() {
        this.emf.verifyOpen();
        this.imap.invalidateAll();
    }

    private Vector createPKVector(Class clazz, Object object) {
        ClassDescriptor classDescriptor = this.serversession.getDescriptor(clazz);
        CMP3Policy cMP3Policy = (CMP3Policy)classDescriptor.getCMPPolicy();
        Vector vector = cMP3Policy.createPkVectorFromKey(object, (AbstractSession)this.serversession);
        return vector;
    }
}

