/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class EntityManagerFactoryProvider {
    public static final HashMap<String, EntityManagerSetupImpl> emSetupImpls = new HashMap();
    public static final HashMap<String, PersistenceUnitInfo> persistenceUnits = new HashMap();
    public static volatile int PUIUsageCount = 0;
    protected static final String[][] oldPropertyNames = new String[][]{{"eclipselink.jdbc.write-connections.max", "eclipselink.max-write-connections"}, {"eclipselink.jdbc.write-connections.min", "eclipselink.min-write-connections"}, {"eclipselink.jdbc.read-connections.max", "eclipselink.max-read-connections"}, {"eclipselink.jdbc.read-connections.min", "eclipselink.min-read-connections"}, {"eclipselink.jdbc.bind-parameters", "eclipselink.bind-all-parameters"}, {"eclipselink.target-database", "eclipselink.platform.class.name"}, {"eclipselink.target-server", "eclipselink.server.platform.class.name"}, {"eclipselink.cache.size.default", "eclipselink.cache.default-size"}};

    public static void addEntityManagerSetupImpl(String string, EntityManagerSetupImpl entityManagerSetupImpl) {
        if (string == null) {
            emSetupImpls.put("", entityManagerSetupImpl);
        }
        emSetupImpls.put(string, entityManagerSetupImpl);
    }

    protected static String addFileSeperator(String string) {
        int n = string.length();
        if (string.substring(n - 1, n).equals(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    protected static void createOrReplaceDefaultTables(SchemaManager schemaManager, boolean bl) {
        if (bl) {
            schemaManager.replaceDefaultTables(true, true);
        } else {
            schemaManager.createDefaultTables(true);
        }
    }

    protected static void generateDDL(ServerSession serverSession, Map map) {
        boolean bl = false;
        boolean bl2 = false;
        if (null == map) {
            return;
        }
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation", map, "none");
        if ((string = string.toLowerCase()).equals("none")) {
            return;
        }
        if (string.equals("create-tables") || string.equals("drop-and-create-tables")) {
            bl = true;
            if (string.equals("drop-and-create-tables")) {
                bl2 = true;
            }
        }
        if (bl) {
            String string2 = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation.output-mode", map, "database");
            if (string2.equals("none")) {
                return;
            }
            SchemaManager schemaManager = new SchemaManager((DatabaseSessionImpl)serverSession);
            if (string2.equals("database") || string2.equals("both")) {
                EntityManagerFactoryProvider.writeDDLToDatabase(schemaManager, bl2);
            }
            if (string2.equals("sql-script") || string2.equals("both")) {
                String string3 = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", map, PersistenceUnitProperties.DEFAULT_APP_LOCATION);
                String string4 = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.create-ddl-jdbc-file-name", map, "createDDL.jdbc");
                String string5 = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.drop-ddl-jdbc-file-name", map, "dropDDL.jdbc");
                EntityManagerFactoryProvider.writeDDLsToFiles(schemaManager, string3, string4, string5);
            }
        }
    }

    public static String getConfigPropertyAsString(String string, Map map) {
        String string2 = null;
        if (map != null) {
            string2 = (String)map.get(string);
        }
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    public static String getConfigPropertyAsString(String string, Map map, String string2) {
        String string3 = EntityManagerFactoryProvider.getConfigPropertyAsString(string, map);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected static String getConfigPropertyAsStringLogDebug(String string, Map map, AbstractSession abstractSession) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(string, map, abstractSession);
    }

    protected static String getConfigPropertyAsStringLogDebug(String string, Map map, AbstractSession abstractSession, boolean bl) {
        return (String)EntityManagerFactoryProvider.getConfigPropertyLogDebug(string, map, abstractSession, bl);
    }

    protected static String getConfigPropertyAsStringLogDebug(String string, Map map, String string2, AbstractSession abstractSession) {
        String string3 = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(string, map, abstractSession);
        if (string3 == null) {
            string3 = string2;
            abstractSession.log(1, "properties", "property_value_default", new Object[]{string, string3});
        }
        return string3;
    }

    protected static Object getConfigPropertyLogDebug(String string, Map map, AbstractSession abstractSession) {
        return EntityManagerFactoryProvider.getConfigPropertyLogDebug(string, map, abstractSession, true);
    }

    protected static Object getConfigPropertyLogDebug(String string, Map map, AbstractSession abstractSession, boolean bl) {
        String string2 = null;
        if (map != null) {
            string2 = (String)map.get(string);
        }
        if (string2 == null && bl) {
            string2 = System.getProperty(string);
        }
        if (string2 != null && abstractSession != null && abstractSession.shouldLog(1, "properties")) {
            String string3 = PersistenceUnitProperties.getOverriddenLogStringForProperty((String)string);
            String string4 = string3 == null ? string2 : string3;
            abstractSession.log(1, "properties", "property_value_specified", new Object[]{string, string4});
        }
        return string2;
    }

    public static EntityManagerSetupImpl getEntityManagerSetupImpl(String string) {
        if (string == null) {
            return emSetupImpls.get("");
        }
        return emSetupImpls.get(string);
    }

    public static PersistenceUnitInfo getPersistenceUnitInfo(String string) {
        if (string == null) {
            return persistenceUnits.get("");
        }
        return persistenceUnits.get(string);
    }

    protected static void login(ServerSession serverSession, Map map) {
        String string = (String)map.get("eclipselink.target-database");
        if (!serverSession.isConnected()) {
            if (string == null || string.equals("Auto")) {
                serverSession.loginAndDetectDatasource();
            } else {
                serverSession.login();
            }
        }
    }

    public static Map mergeMaps(Map map, Map map2) {
        HashMap hashMap = new HashMap();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    protected static void translateOldProperties(Map map, AbstractSession abstractSession) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            String string = EntityManagerFactoryProvider.getConfigPropertyAsString(oldPropertyNames[i][1], map);
            if (string == null) continue;
            if (abstractSession != null) {
                abstractSession.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
            }
            map.put(oldPropertyNames[i][0], string);
        }
    }

    protected static void warnOldProperties(Map map, AbstractSession abstractSession) {
        for (int i = 0; i < oldPropertyNames.length; ++i) {
            Object v = map.get(oldPropertyNames[i][1]);
            if (v == null) continue;
            abstractSession.log(5, "transaction", "deprecated_property", oldPropertyNames[i]);
        }
    }

    protected static void writeDDLToDatabase(SchemaManager schemaManager, boolean bl) {
        String string = EntityManagerFactoryProvider.getConfigPropertyAsString("INTERACT_WITH_DB", null, "true");
        boolean bl2 = Boolean.valueOf(string.toLowerCase());
        if (!bl2) {
            return;
        }
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(schemaManager, bl);
    }

    protected static void writeDDLsToFiles(SchemaManager schemaManager, String string, String string2, String string3) {
        String string4;
        string = EntityManagerFactoryProvider.addFileSeperator(string);
        if (null != string2) {
            string4 = string + string2;
            schemaManager.outputCreateDDLToFile(string4);
        }
        if (null != string3) {
            string4 = string + string3;
            schemaManager.outputDropDDLToFile(string4);
        }
        schemaManager.setCreateSQLFiles(false);
        EntityManagerFactoryProvider.createOrReplaceDefaultTables(schemaManager, true);
        schemaManager.closeDDLWriter();
    }
}

