/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;

public class EmbeddableAccessor
extends ClassAccessor {
    public EmbeddableAccessor() {
        super("<embeddable>");
    }

    public EmbeddableAccessor(Annotation annotation, Class clazz, MetadataProject metadataProject) {
        super(annotation, clazz, metadataProject);
    }

    public void process() {
        if (this.isAnnotationPresent(Cache.class)) {
            throw ValidationException.cacheNotSupportedWithEmbeddable((Class)this.getJavaClass());
        }
        this.processEmbeddable();
        this.processCustomizer();
        this.processConverters();
        this.processCopyPolicy();
        this.processChangeTracking();
        this.processProperties();
        this.processAccessors();
    }

    public void processAccessType() {
        String string = this.getOwningDescriptor().getClassAccessor().getAccessType();
        this.getDescriptor().setDefaultAccess(string);
        if (this.getAccess() == null) {
            this.getLogger().logConfigMessage("metadata_access_type", string, (Object)this.getJavaClass());
        }
    }

    protected void processEmbeddable() {
        this.processAccessType();
        if (this.getMetadataComplete() != null) {
            this.getDescriptor().setIgnoreAnnotations(this.isMetadataComplete());
        }
        if (this.getExcludeDefaultMappings() != null) {
            this.getDescriptor().setIgnoreDefaultMappings(this.excludeDefaultMappings());
        }
    }
}

