/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class DiscriminatorColumnMetadata
extends ORMetadata {
    private Enum m_discriminatorType;
    private Integer m_length;
    private String m_columnDefinition;
    private String m_name;

    public DiscriminatorColumnMetadata() {
        super("<discriminator-column>");
    }

    public DiscriminatorColumnMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        if (annotation != null) {
            this.m_columnDefinition = (String)MetadataHelper.invokeMethod("columnDefinition", annotation);
            this.m_discriminatorType = (Enum)MetadataHelper.invokeMethod("discriminatorType", annotation);
            this.m_length = (Integer)MetadataHelper.invokeMethod("length", annotation);
            this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        }
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public Enum getDiscriminatorType() {
        return this.m_discriminatorType;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseField process(MetadataDescriptor metadataDescriptor, String string, String string2) {
        DatabaseField databaseField = new DatabaseField();
        databaseField.setName(MetadataHelper.getName(this.m_name, "DTYPE", string2, metadataDescriptor.getLogger(), string));
        databaseField.setLength(MetadataHelper.getValue(this.m_length, 31).intValue());
        databaseField.setColumnDefinition(MetadataHelper.getValue(this.m_columnDefinition, ""));
        if (this.m_discriminatorType == null || this.m_discriminatorType.name().equals(DiscriminatorType.STRING.name())) {
            databaseField.setType(String.class);
        } else if (this.m_discriminatorType.name().equals(DiscriminatorType.CHAR.name())) {
            databaseField.setType(Character.class);
        } else {
            databaseField.setType(Integer.class);
        }
        databaseField.setTable(metadataDescriptor.getPrimaryTable());
        return databaseField;
    }

    public void setColumnDefinition(String string) {
        this.m_columnDefinition = string;
    }

    public void setDiscriminatorType(Enum enum_) {
        this.m_discriminatorType = enum_;
    }

    public void setLength(Integer n) {
        this.m_length = n;
    }

    public void setName(String string) {
        this.m_name = string;
    }
}

