/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConverterMetadata
extends AbstractConverterMetadata {
    private String m_className;

    public ConverterMetadata() {
        super("<converter>");
    }

    public ConverterMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_className = ((Class)MetadataHelper.invokeMethod("converterClass", annotation)).getName();
    }

    public boolean equals(Object object) {
        if (object instanceof ConverterMetadata) {
            ConverterMetadata converterMetadata = (ConverterMetadata)object;
            if (!this.valuesMatch(this.getName(), converterMetadata.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_className, converterMetadata.getClassName());
        }
        return false;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_className = this.initXMLClassName(this.m_className).getName();
    }

    public void process(DatabaseMapping databaseMapping, DirectAccessor directAccessor) {
        directAccessor.setConverterClassName(databaseMapping, this.getClassName());
    }

    public void setClassName(String string) {
        this.m_className = string;
    }
}

