/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends NamedQueryMetadata {
    private Class m_resultClass;
    private String m_resultClassName;
    private String m_resultSetMapping;

    public NamedNativeQueryMetadata() {
        super("<named-native-query>");
    }

    protected NamedNativeQueryMetadata(String string) {
        super(string);
    }

    public NamedNativeQueryMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_resultClass = (Class)MetadataHelper.invokeMethod("resultClass", annotation);
        this.m_resultSetMapping = (String)MetadataHelper.invokeMethod("resultSetMapping", annotation);
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata namedNativeQueryMetadata = (NamedNativeQueryMetadata)object;
            if (!this.valuesMatch(this.m_resultClass, namedNativeQueryMetadata.getResultClass())) {
                return false;
            }
            return this.valuesMatch(this.m_resultSetMapping, namedNativeQueryMetadata.getResultSetMapping());
        }
        return false;
    }

    public Class getResultClass() {
        return this.m_resultClass;
    }

    public String getResultClassName() {
        return this.m_resultClassName;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_resultClass = this.initXMLClassName(this.m_resultClassName);
    }

    public void process(AbstractSession abstractSession, ClassLoader classLoader) {
        Map<String, Object> map = this.processQueryHints(abstractSession);
        if (this.m_resultClass == Void.TYPE) {
            if (this.m_resultSetMapping.equals("")) {
                abstractSession.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.getQuery(), map, classLoader));
            } else {
                abstractSession.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.m_resultSetMapping, this.getQuery(), map, classLoader));
            }
        } else {
            abstractSession.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(MetadataHelper.getClassForName(this.m_resultClass.getName(), classLoader), this.getQuery(), map, classLoader));
        }
    }

    public void setResultClass(Class clazz) {
        this.m_resultClass = clazz;
    }

    public void setResultClassName(String string) {
        this.m_resultClassName = string;
    }

    protected void setResultSetMapping(String string) {
        this.m_resultSetMapping = string;
    }
}

