/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class ParameterizedSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected DatabaseCall previousCall;
    protected ArrayList parameters;
    protected DatabaseCall lastCallAppended;
    protected int executionCount;
    protected int statementCount;

    public ParameterizedSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.parameters = new ArrayList(10);
    }

    public void appendCall(AbstractSession abstractSession, DatabaseCall databaseCall) {
        if (databaseCall != null) {
            this.cacheQueryTimeout(abstractSession, databaseCall);
        }
        if (databaseCall.hasParameters()) {
            if (this.previousCall == null) {
                this.previousCall = databaseCall;
                this.parameters.add(databaseCall.getParameters());
            } else if (this.previousCall.getSQLString().equals(databaseCall.getSQLString()) && this.parameters.size() < this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize()) {
                this.parameters.add(databaseCall.getParameters());
            } else {
                this.executeBatchedStatements(abstractSession);
                this.appendCall(abstractSession, databaseCall);
            }
            this.lastCallAppended = databaseCall;
            if (((ModifyQuery)databaseCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(abstractSession);
            }
        } else {
            this.executeBatchedStatements(abstractSession);
            this.switchMechanisms(abstractSession, databaseCall);
        }
    }

    public void clear() {
        this.previousCall = null;
        this.parameters.clear();
        this.executionCount = 0;
        this.statementCount = 0;
        this.clearCacheQueryTimeout();
        this.lastCallAppended = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchedStatements(AbstractSession abstractSession) {
        Object object;
        if (this.parameters.isEmpty()) {
            return;
        }
        abstractSession.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
        if (abstractSession.shouldLog(3, "sql")) {
            abstractSession.log(3, "sql", this.previousCall.getSQLString(), null, this.databaseAccessor, false);
            object = this.parameters.iterator();
            while (object.hasNext()) {
                StringWriter stringWriter = new StringWriter();
                DatabaseCall.appendLogParameters((Collection)object.next(), this.databaseAccessor, stringWriter, abstractSession);
                abstractSession.log(3, "sql", stringWriter.toString(), null, this.databaseAccessor, false);
            }
        }
        abstractSession.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
        try {
            this.databaseAccessor.incrementCallCount(abstractSession);
            object = this.prepareBatchStatements(abstractSession);
            this.executionCount += this.databaseAccessor.executeJDK12BatchStatement((Statement)object, this.lastCallAppended, abstractSession, true);
            ++this.databaseAccessor.writeStatementsCount;
            if (this.previousCall.hasOptimisticLock() && this.executionCount != this.statementCount) {
                throw OptimisticLockException.batchStatementExecutionFailure();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(AbstractSession abstractSession, DatabaseCall databaseCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToDynamicSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism().appendCall(abstractSession, databaseCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement prepareBatchStatements(AbstractSession abstractSession) throws DatabaseException {
        PreparedStatement preparedStatement = null;
        try {
            abstractSession.startOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            try {
                boolean bl = abstractSession.getPlatform().usesNativeBatchWriting();
                preparedStatement = (PreparedStatement)this.databaseAccessor.prepareStatement(this.previousCall, abstractSession, bl);
                this.databaseAccessor.getPlatform().prepareBatchStatement(preparedStatement);
                if (this.queryTimeoutCache > 0) {
                    preparedStatement.setQueryTimeout(this.queryTimeoutCache);
                }
                for (int i = 0; i < this.parameters.size(); ++i) {
                    List list = (List)this.parameters.get(i);
                    int n = list.size();
                    for (int j = 0; j < n; ++j) {
                        abstractSession.getPlatform().setParameterValueInDatabaseCall(list.get(j), preparedStatement, j + 1, abstractSession);
                    }
                    ++this.statementCount;
                    this.executionCount += this.databaseAccessor.getPlatform().addBatch(preparedStatement);
                }
            }
            finally {
                abstractSession.endOperationProfile("sql prepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException sQLException) {
            DatabaseException databaseException = this.databaseAccessor.processExceptionForCommError(abstractSession, sQLException, this.lastCallAppended);
            try {
                this.databaseAccessor.closeStatement(preparedStatement, abstractSession, null);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (databaseException == null) {
                throw DatabaseException.sqlException(sQLException, this.databaseAccessor, abstractSession, false);
            }
            throw databaseException;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.databaseAccessor.closeStatement(preparedStatement, abstractSession, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        return preparedStatement;
    }
}

