/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable databaseTable) {
        this.table = databaseTable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TableExpression tableExpression = (TableExpression)object;
        return this.getTable() == tableExpression.getTable() || this.getTable() != null && this.getTable().equals(tableExpression.getTable());
    }

    public int computeHashCode() {
        int n = super.computeHashCode();
        if (this.getTable() != null) {
            n += this.getTable().hashCode();
        }
        return n;
    }

    public String descriptionOfNodeType() {
        return "Table";
    }

    public Expression getField(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        if (!databaseField.hasTableName()) {
            databaseField.setTable(this.getTable());
        }
        return this.getField(databaseField);
    }

    public Vector getOwnedTables() {
        Vector<DatabaseTable> vector = new Vector<DatabaseTable>(1);
        vector.addElement(this.getTable());
        return vector;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public boolean isTableExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        if (this.getTable().getTableQualifier().length() == 0 && expressionNormalizer.getSession().getDatasourceLogin().getTableQualifier().length() != 0) {
            this.getTable().setTableQualifier(expressionNormalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(expressionNormalizer);
    }

    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        return expression2.getTable(this.getTable());
    }

    public void setTable(DatabaseTable databaseTable) {
        this.table = databaseTable;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        return expression3.getTable(this.getTable());
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getTable().toString());
        bufferedWriter.write(this.tableAliasesDescription());
    }
}

