/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyManager
implements Serializable {
    protected int numberOfReaders = 0;
    protected int depth = 0;
    protected int numberOfWritersWaiting = 0;
    protected transient Thread activeThread;
    public static Map<Thread, DeferredLockManager> deferredLockManagers = ConcurrencyManager.initializeDeferredLockManagers();
    protected boolean lockedByMergeManager;
    protected CacheKey ownerCacheKey;

    public ConcurrencyManager() {
    }

    public ConcurrencyManager(CacheKey cacheKey) {
        this();
        this.ownerCacheKey = cacheKey;
    }

    public void acquire() throws ConcurrencyException {
        this.acquire(false);
    }

    public synchronized void acquire(boolean bl) throws ConcurrencyException {
        while ((this.activeThread != null || this.numberOfReaders > 0) && this.activeThread != Thread.currentThread()) {
            try {
                ++this.numberOfWritersWaiting;
                this.wait();
                --this.numberOfWritersWaiting;
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
            }
        }
        if (this.activeThread == null) {
            this.activeThread = Thread.currentThread();
        }
        this.lockedByMergeManager = bl;
        ++this.depth;
    }

    public boolean acquireNoWait() throws ConcurrencyException {
        return this.acquireNoWait(false);
    }

    public synchronized boolean acquireNoWait(boolean bl) throws ConcurrencyException {
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquire(bl);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireWithWait(boolean bl, int n) throws ConcurrencyException {
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquire(bl);
            return true;
        }
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquire(bl);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireIfUnownedNoWait(boolean bl) throws ConcurrencyException {
        if (this.activeThread == null) {
            this.acquire(bl);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDeferredLock() throws ConcurrencyException {
        Thread thread = Thread.currentThread();
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            deferredLockManager = new DeferredLockManager();
            this.putDeferredLock(thread, deferredLockManager);
        }
        deferredLockManager.incrementDepth();
        ConcurrencyManager concurrencyManager = this;
        synchronized (concurrencyManager) {
            while (this.numberOfReaders != 0) {
                try {
                    ++this.numberOfWritersWaiting;
                    this.wait();
                    --this.numberOfWritersWaiting;
                }
                catch (InterruptedException interruptedException) {
                    throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
                }
            }
            if (this.activeThread == thread || !this.isAcquired()) {
                deferredLockManager.addActiveLock(this);
                this.acquire();
            } else {
                deferredLockManager.addDeferredLock(this);
                if (AbstractSessionLog.getLog().shouldLog(2)) {
                    AbstractSessionLog.getLog().log(2, "acquiring_deferred_lock", this.getOwnerCacheKey().getObject(), thread.getName());
                }
            }
        }
    }

    public void checkDeferredLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireDeferredLock();
        this.releaseDeferredLock();
    }

    public void checkReadLock() throws ConcurrencyException {
        if (this.activeThread == null) {
            return;
        }
        this.acquireReadLock();
        this.releaseReadLock();
    }

    public synchronized void acquireReadLock() throws ConcurrencyException {
        while (this.activeThread != null && this.activeThread != Thread.currentThread()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
            }
        }
        ++this.numberOfReaders;
    }

    public synchronized boolean acquireReadLockNoWait() {
        if (this.activeThread == null || this.activeThread == Thread.currentThread()) {
            this.acquireReadLock();
            return true;
        }
        return false;
    }

    public Thread getActiveThread() {
        return this.activeThread;
    }

    public static DeferredLockManager getDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().get(thread);
    }

    protected static Map<Thread, DeferredLockManager> getDeferredLockManagers() {
        return deferredLockManagers;
    }

    protected static Map initializeDeferredLockManagers() {
        return new ConcurrentHashMap();
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNumberOfReaders() {
        return this.numberOfReaders;
    }

    public int getNumberOfWritersWaiting() {
        return this.numberOfWritersWaiting;
    }

    public CacheKey getOwnerCacheKey() {
        return this.ownerCacheKey;
    }

    public boolean isAcquired() {
        return this.depth > 0;
    }

    public boolean isLockedByMergeManager() {
        return this.lockedByMergeManager;
    }

    public static boolean isBuildObjectOnThreadComplete(Thread thread, Map map) {
        if (map.containsKey(thread)) {
            return true;
        }
        map.put(thread, thread);
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            return true;
        }
        Vector vector = deferredLockManager.getDeferredLocks();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConcurrencyManager concurrencyManager = (ConcurrencyManager)enumeration.nextElement();
            Thread thread2 = null;
            if (!concurrencyManager.isAcquired() || (thread2 = concurrencyManager.getActiveThread()) == null) continue;
            DeferredLockManager deferredLockManager2 = ConcurrencyManager.getDeferredLockManager(thread2);
            if (deferredLockManager2 == null) {
                return false;
            }
            if (deferredLockManager2.isThreadComplete()) {
                thread2 = concurrencyManager.getActiveThread();
                if (thread2 == null || ConcurrencyManager.isBuildObjectOnThreadComplete(thread2, map)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNested() {
        return this.depth > 1;
    }

    public void putDeferredLock(Thread thread, DeferredLockManager deferredLockManager) {
        ConcurrencyManager.getDeferredLockManagers().put(thread, deferredLockManager);
    }

    public synchronized void release() throws ConcurrencyException {
        if (this.depth == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        --this.depth;
        if (this.depth == 0) {
            this.activeThread = null;
            this.lockedByMergeManager = false;
            this.notifyAll();
        }
    }

    public void releaseDeferredLock() throws ConcurrencyException {
        Thread thread = Thread.currentThread();
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            return;
        }
        int n = deferredLockManager.getThreadDepth();
        if (n > 1) {
            deferredLockManager.decrementDepth();
            return;
        }
        if (!deferredLockManager.hasDeferredLock()) {
            deferredLockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(thread);
            return;
        }
        deferredLockManager.setIsThreadComplete(true);
        while (true) {
            IdentityHashMap identityHashMap;
            if (ConcurrencyManager.isBuildObjectOnThreadComplete(thread, identityHashMap = new IdentityHashMap())) {
                deferredLockManager.releaseActiveLocksOnThread();
                ConcurrencyManager.removeDeferredLockManager(thread);
                AbstractSessionLog.getLog().log(2, "deferred_locks_released", thread.getName());
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void releaseReadLock() throws ConcurrencyException {
        if (this.numberOfReaders == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        --this.numberOfReaders;
        if (this.numberOfReaders == 0) {
            this.notifyAll();
        }
    }

    public static DeferredLockManager removeDeferredLockManager(Thread thread) {
        return ConcurrencyManager.getDeferredLockManagers().remove(thread);
    }

    public void setActiveThread(Thread thread) {
        this.activeThread = thread;
    }

    protected void setDepth(int n) {
        this.depth = n;
    }

    public void setIsLockedByMergeManager(boolean bl) {
        this.lockedByMergeManager = bl;
    }

    protected void setNumberOfReaders(int n) {
        this.numberOfReaders = n;
    }

    protected void setNumberOfWritersWaiting(int n) {
        this.numberOfWritersWaiting = n;
    }

    public synchronized void transitionToDeferredLock() {
        Thread thread = Thread.currentThread();
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            deferredLockManager = new DeferredLockManager();
            this.putDeferredLock(thread, deferredLockManager);
        }
        deferredLockManager.incrementDepth();
        deferredLockManager.addActiveLock(this);
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.getDepth())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("nest_level", objectArray);
    }
}

