/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.history;

import java.io.StringWriter;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

public class HistoricalSession
extends AbstractSession {
    protected final AbstractSession parent;
    protected final AsOfClause asOfClause;

    public HistoricalSession(AbstractSession abstractSession, AsOfClause asOfClause) {
        this.asOfClause = asOfClause;
        this.parent = abstractSession;
        this.project = abstractSession.getProject();
        this.queries = abstractSession.getQueries();
        this.profiler = abstractSession.getProfiler();
        this.sessionLog = abstractSession.getSessionLog();
        this.eventManager = abstractSession.getEventManager().clone(this);
        this.exceptionHandler = abstractSession.getExceptionHandler();
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".acquireUnitOfWork");
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".beginTransaction");
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".commitTransaction");
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public Object getAsOfValue() {
        return this.getAsOfClause().getValue();
    }

    public AbstractSession getParent() {
        return this.parent;
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public boolean hasAsOfClause() {
        return this.asOfClause != null && this.asOfClause.getValue() != null;
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException {
        if (!databaseQuery.isReadQuery()) {
            throw QueryException.invalidQueryOnHistoricalSession(databaseQuery);
        }
        return super.internalExecuteQuery(databaseQuery, abstractRecord);
    }

    public boolean isInTransaction() {
        return false;
    }

    public boolean isHistoricalSession() {
        return true;
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery databaseQuery) {
        DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.clone();
        databaseQuery2.setIsExecutionClone(true);
        databaseQuery2.setIsPrepared(false);
        return databaseQuery2;
    }

    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".rollbackTransaction");
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString());
        stringWriter.write("(");
        stringWriter.write(this.getAsOfClause().toString());
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

