/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.sessions.Record;

public class CacheKey
implements Serializable,
Cloneable {
    protected Vector key;
    protected int hash;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected ConcurrencyManager mutex;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    public static final int MAX_WAIT_TRIES = 10000;
    protected long readTime = 0L;
    protected boolean isWrapper = false;

    protected CacheKey() {
    }

    public CacheKey(Vector vector) {
        this.key = vector;
        this.hash = this.computeHash(vector);
    }

    public CacheKey(Vector vector, Object object, Object object2) {
        this.key = vector;
        this.hash = this.computeHash(vector);
        this.writeLockValue = object2;
        if (object != null) {
            this.setObject(object);
        }
    }

    public CacheKey(Vector vector, Object object, Object object2, long l) {
        this.key = vector;
        this.hash = this.computeHash(vector);
        this.writeLockValue = object2;
        if (object != null) {
            this.setObject(object);
        }
        this.readTime = l;
    }

    public void acquire() {
        this.getMutex().acquire(false);
    }

    public void acquire(boolean bl) {
        this.getMutex().acquire(bl);
    }

    public boolean acquireNoWait() {
        return this.getMutex().acquireNoWait(false);
    }

    public boolean acquireIfUnownedNoWait() {
        return this.getMutex().acquireIfUnownedNoWait(false);
    }

    public boolean acquireNoWait(boolean bl) {
        return this.getMutex().acquireNoWait(bl);
    }

    public boolean acquireWithWait(boolean bl, int n) {
        return this.getMutex().acquireWithWait(bl, n);
    }

    public void acquireDeferredLock() {
        this.getMutex().acquireDeferredLock();
    }

    public void checkReadLock() {
        this.getMutex().checkReadLock();
    }

    public void checkDeferredLock() {
        this.getMutex().checkDeferredLock();
    }

    public void acquireReadLock() {
        this.getMutex().acquireReadLock();
    }

    public boolean acquireReadLockNoWait() {
        return this.getMutex().acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    protected int computeHash(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            Object e = vector.get(i);
            if (e == null) continue;
            if (e.getClass().isArray()) {
                n ^= this.computeArrayHashCode(e);
                continue;
            }
            n ^= e.hashCode();
        }
        return n;
    }

    private int computeArrayHashCode(Object object) {
        if (object.getClass() == ClassConstants.APBYTE) {
            return Arrays.hashCode((byte[])object);
        }
        if (object.getClass() == ClassConstants.APCHAR) {
            return Arrays.hashCode((char[])object);
        }
        return Arrays.hashCode((Object[])object);
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheKey)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(CacheKey cacheKey) {
        if (this == cacheKey) {
            return true;
        }
        int n = this.key.size();
        if (n == cacheKey.key.size()) {
            for (int i = 0; i < n; ++i) {
                Object e = this.key.get(i);
                Object e2 = cacheKey.key.get(i);
                if (!(e == null ? e2 != null : (e.getClass().isArray() ? (e.getClass() == ClassConstants.APBYTE && e2.getClass() == ClassConstants.APBYTE ? !Helper.compareByteArrays((byte[])e, (byte[])e2) : (e.getClass() == ClassConstants.APCHAR && e2.getClass() == ClassConstants.APCHAR ? !Helper.compareCharArrays((char[])e, (char[])e2) : !Helper.compareArrays((Object[])e, (Object[])e2))) : !e.equals(e2)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Vector getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyManager getMutex() {
        if (this.mutex == null) {
            CacheKey cacheKey = this;
            synchronized (cacheKey) {
                if (this.mutex == null) {
                    this.mutex = new ConcurrencyManager(this);
                }
            }
        }
        return this.mutex;
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public CacheKey getWrappedCacheKey() {
        return this;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAcquired() {
        return this.getMutex().isAcquired();
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    public void release() {
        this.getMutex().release();
    }

    public void releaseDeferredLock() {
        this.getMutex().releaseDeferredLock();
    }

    public void releaseReadLock() {
        this.getMutex().releaseReadLock();
    }

    public Object removeFromOwningMap() {
        if (this.getOwningMap() != null) {
            return this.getOwningMap().remove(this);
        }
        return null;
    }

    public void setInvalidationState(int n) {
        this.invalidationState = n;
    }

    public void setLastUpdatedQueryId(long l) {
        this.lastUpdatedQueryId = l;
    }

    public void setKey(Vector vector) {
        this.key = vector;
        this.hash = this.computeHash(vector);
    }

    public void setMutex(ConcurrencyManager concurrencyManager) {
        this.mutex = concurrencyManager;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap identityMap) {
        this.mapOwner = identityMap;
    }

    public void setReadTime(long l) {
        this.readTime = l;
        this.invalidationState = 0;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setWrapper(Object object) {
        this.wrapper = object;
    }

    public void setWriteLockValue(Object object) {
        this.writeLockValue = object;
    }

    public String toString() {
        int n = 0;
        if (this.getObject() != null) {
            n = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + n + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void transitionToDeferredLock() {
        this.getMutex().transitionToDeferredLock();
    }

    public void updateAccess() {
    }

    public void setIsWrapper(boolean bl) {
        this.isWrapper = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForObject() {
        ConcurrencyManager concurrencyManager = this.getMutex();
        synchronized (concurrencyManager) {
            try {
                int n = 0;
                while (this.object == null && this.isAcquired()) {
                    if (n > 10000) {
                        throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(this.getMutex().getActiveThread(), Thread.currentThread());
                    }
                    this.getMutex().wait(10L);
                    ++n;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.object;
        }
    }
}

