/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilder
extends ObjectBuilder {
    private Boolean isXMLDescriptor;

    public XMLObjectBuilder(ClassDescriptor classDescriptor) {
        super(classDescriptor);
    }

    public AbstractRecord buildRow(Object object, AbstractSession abstractSession, DatabaseField databaseField, XMLRecord xMLRecord) {
        return this.buildRow(object, abstractSession, databaseField, xMLRecord, false);
    }

    public AbstractRecord buildRow(Object object, AbstractSession abstractSession, DatabaseField databaseField, XMLRecord xMLRecord, boolean bl) {
        Cloneable cloneable;
        Vector vector;
        if (this.isXmlDescriptor() && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            vector = this.extractPrimaryKeyFromObject(object, abstractSession);
            if (vector == null || vector.size() == 0) {
                vector = new Vector();
                vector.addElement(new WeakObjectWrapper(object));
            }
            if ((cloneable = abstractSession.getIdentityMapAccessorInstance().getCacheKeyForObject(vector, this.getDescriptor().getJavaClass(), this.getDescriptor())) != null && ((CacheKey)cloneable).getRecord() != null) {
                XMLRecord xMLRecord2 = (XMLRecord)((CacheKey)cloneable).getRecord();
                xMLRecord2.setMarshaller(xMLRecord.getMarshaller());
                xMLRecord2.setLeafElementType(xMLRecord.getLeafElementType());
                xMLRecord.setLeafElementType(null);
                return this.buildIntoNestedRow(xMLRecord2, object, abstractSession, bl);
            }
        }
        vector = XPathEngine.getInstance().createUnownedElement(xMLRecord.getDOM(), (XMLField)databaseField);
        cloneable = new DOMRecord((Element)((Object)vector));
        ((XMLRecord)cloneable).setNamespaceResolver(xMLRecord.getNamespaceResolver());
        ((XMLRecord)cloneable).setMarshaller(xMLRecord.getMarshaller());
        ((XMLRecord)cloneable).setLeafElementType(xMLRecord.getLeafElementType());
        xMLRecord.setLeafElementType(null);
        return this.buildIntoNestedRow((AbstractRecord)cloneable, object, abstractSession, bl);
    }

    public AbstractRecord createRecord(AbstractSession abstractSession) {
        return this.createRecord(this.getDescriptor().getTableName(), abstractSession);
    }

    public AbstractRecord createRecord(int n, AbstractSession abstractSession) {
        return this.createRecord(this.getDescriptor().getTableName(), abstractSession);
    }

    public AbstractRecord createRecord(String string, AbstractSession abstractSession) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord dOMRecord = new DOMRecord(string, namespaceResolver);
        dOMRecord.setSession(abstractSession);
        return dOMRecord;
    }

    public AbstractRecord createRecord(String string, String string2, AbstractSession abstractSession) {
        DOMRecord dOMRecord = new DOMRecord(string, string2);
        dOMRecord.setSession(abstractSession);
        return dOMRecord;
    }

    public AbstractRecord createRecord(String string, Node node, AbstractSession abstractSession) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord dOMRecord = new DOMRecord(string, namespaceResolver, node);
        dOMRecord.setSession(abstractSession);
        return dOMRecord;
    }

    public AbstractRecord createRecordFor(Object object, XMLField xMLField, XMLRecord xMLRecord, XMLMapping xMLMapping) {
        DocumentPreservationPolicy documentPreservationPolicy = xMLRecord.getDocPresPolicy();
        Element element = null;
        if (documentPreservationPolicy != null) {
            element = (Element)documentPreservationPolicy.getNodeForObject(object);
        }
        if (element == null) {
            element = XPathEngine.getInstance().createUnownedElement(xMLRecord.getDOM(), xMLField);
            if (xMLField.isSelfField()) {
                documentPreservationPolicy.addObjectToCache(object, element, xMLMapping);
            } else {
                documentPreservationPolicy.addObjectToCache(object, element);
            }
        }
        DOMRecord dOMRecord = new DOMRecord(element);
        dOMRecord.setMarshaller(xMLRecord.getMarshaller());
        dOMRecord.setLeafElementType(xMLRecord.getLeafElementType());
        xMLRecord.setLeafElementType(null);
        dOMRecord.setDocPresPolicy(documentPreservationPolicy);
        return dOMRecord;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy documentPreservationPolicy) {
        Element element = null;
        DOMRecord dOMRecord = null;
        if (documentPreservationPolicy != null) {
            element = (Element)documentPreservationPolicy.getNodeForObject(object);
        }
        if (element == null) {
            dOMRecord = new DOMRecord(this.getDescriptor().getTableName(), this.getNamespaceResolver());
            documentPreservationPolicy.addObjectToCache(object, ((XMLRecord)dOMRecord).getDOM());
        } else {
            dOMRecord = new DOMRecord(element);
        }
        dOMRecord.setDocPresPolicy(documentPreservationPolicy);
        return dOMRecord;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy documentPreservationPolicy, String string, String string2) {
        Element element = null;
        DOMRecord dOMRecord = null;
        if (documentPreservationPolicy != null) {
            element = (Element)documentPreservationPolicy.getNodeForObject(object);
        }
        if (element == null) {
            dOMRecord = new DOMRecord(string, string2);
            documentPreservationPolicy.addObjectToCache(object, ((XMLRecord)dOMRecord).getDOM());
        } else {
            dOMRecord = new DOMRecord(element);
        }
        dOMRecord.setDocPresPolicy(documentPreservationPolicy);
        return dOMRecord;
    }

    protected AbstractRecord createRecordForPKExtraction(int n, AbstractSession abstractSession) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord dOMRecord = new DOMRecord(this.getDescriptor().getTableName(), namespaceResolver);
        dOMRecord.setSession(abstractSession);
        return dOMRecord;
    }

    public Object buildObject(ObjectBuildingQuery objectBuildingQuery, AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager) throws DatabaseException, QueryException {
        Object object;
        XMLRecord xMLRecord = (XMLRecord)abstractRecord;
        xMLRecord.setSession(objectBuildingQuery.getSession());
        XMLUnmarshaller xMLUnmarshaller = xMLRecord.getUnmarshaller();
        Object object2 = xMLRecord.getOwningObject();
        Vector<WeakObjectWrapper> vector = this.extractPrimaryKeyFromRow(abstractRecord, objectBuildingQuery.getSession());
        if (!(this.isXmlDescriptor() || this.getDescriptor().isAggregateDescriptor() || this.getDescriptor().isAggregateCollectionDescriptor())) {
            return super.buildObject(objectBuildingQuery, abstractRecord, joinedAttributeManager);
        }
        objectBuildingQuery.getSession().startOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
        ClassDescriptor classDescriptor = this.getDescriptor();
        Object object3 = null;
        if (classDescriptor.hasInheritance() && object2 == null) {
            QName qName;
            object = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord, objectBuildingQuery.getSession());
            if (object == null && this.isXmlDescriptor() && (qName = ((XMLDescriptor)classDescriptor).getDefaultRootElementType()) != null) {
                Object v = classDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(qName);
                if (v == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(qName, classDescriptor.getInheritancePolicy().getDescriptor());
                }
                object = (Class)v;
            }
            if (object != null) {
                classDescriptor = objectBuildingQuery.getSession().getDescriptor((Class)object);
                if (classDescriptor == null && objectBuildingQuery.hasPartialAttributeExpressions()) {
                    classDescriptor = this.getDescriptor();
                }
                if (classDescriptor == null) {
                    throw QueryException.noDescriptorForClassFromInheritancePolicy(objectBuildingQuery, (Class)object);
                }
            } else if (Modifier.isAbstract(classDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(abstractRecord, classDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        object3 = classDescriptor.getObjectBuilder().buildNewInstance();
        xMLRecord.setCurrentObject(object3);
        if (xMLUnmarshaller != null && xMLUnmarshaller.getUnmarshalListener() != null) {
            xMLUnmarshaller.getUnmarshalListener().beforeUnmarshal(object3, object2);
        }
        classDescriptor.getObjectBuilder().buildAttributesIntoObject(object3, abstractRecord, objectBuildingQuery, joinedAttributeManager, false);
        if (this.isXmlDescriptor() && ((XMLDescriptor)classDescriptor).getPrimaryKeyFieldNames().size() > 0) {
            if (vector == null || vector.size() == 0) {
                vector = new Vector<WeakObjectWrapper>();
                vector.addElement(new WeakObjectWrapper(object3));
            }
            object = objectBuildingQuery.getSession().getIdentityMapAccessorInstance().acquireDeferredLock(vector, classDescriptor.getJavaClass(), classDescriptor);
            if (((XMLDescriptor)classDescriptor).shouldPreserveDocument()) {
                ((CacheKey)object).setRecord(abstractRecord);
            }
            ((CacheKey)object).setObject(object3);
            ((CacheKey)object).releaseDeferredLock();
        }
        if ((object = ((DOMRecord)xMLRecord).getDocPresPolicy()) != null) {
            ((DOMRecord)xMLRecord).getDocPresPolicy().addObjectToCache(object3, ((DOMRecord)xMLRecord).getDOM());
        }
        objectBuildingQuery.getSession().endOperationProfile("object building", objectBuildingQuery, Integer.MAX_VALUE);
        if (xMLUnmarshaller != null && xMLUnmarshaller.getUnmarshalListener() != null) {
            xMLUnmarshaller.getUnmarshalListener().afterUnmarshal(object3, object2);
        }
        return object3;
    }

    public AbstractRecord buildRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        return this.buildRow(abstractRecord, object, abstractSession, false);
    }

    public AbstractRecord buildRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession, boolean bl) {
        XMLRecord xMLRecord = (XMLRecord)abstractRecord;
        xMLRecord.setSession(abstractSession);
        XMLMarshaller xMLMarshaller = xMLRecord.getMarshaller();
        if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
            xMLMarshaller.getMarshalListener().beforeMarshal(object);
        }
        this.writeOutMappings(xMLRecord, object, abstractSession);
        if (this.getDescriptor().hasInheritance()) {
            QName qName;
            XMLSchemaReference xMLSchemaReference;
            XMLDescriptor xMLDescriptor;
            boolean bl2 = true;
            if (this.isXmlDescriptor() && !bl && (xMLDescriptor = (XMLDescriptor)this.getDescriptor()).getDefaultRootElementType() != null && xMLDescriptor.getSchemaReference() != null && (xMLSchemaReference = xMLDescriptor.getSchemaReference()).getType() == 1 && xMLSchemaReference.isGlobalDefinition() && (qName = xMLSchemaReference.getSchemaContextAsQName(xMLDescriptor.getNamespaceResolver())) != null) {
                bl2 = false;
                if (!qName.equals(xMLDescriptor.getDefaultRootElementType())) {
                    xMLRecord.add(xMLDescriptor.getInheritancePolicy().getClassIndicatorField(), xMLSchemaReference.getSchemaContext().substring(1));
                }
            }
            if (bl2) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(xMLRecord);
            }
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(xMLRecord);
        }
        this.addNamespaceDeclarations(xMLRecord.getDocument());
        if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
            xMLMarshaller.getMarshalListener().afterMarshal(object);
        }
        return xMLRecord;
    }

    public void writeOutMappings(XMLRecord xMLRecord, Object object, AbstractSession abstractSession) {
        Vector<DatabaseMapping> vector = this.getDescriptor().getMappings();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = vector.get(i);
            databaseMapping.writeFromObjectIntoRow(object, xMLRecord, abstractSession);
        }
    }

    public void addNamespaceDeclarations(Document document) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            return;
        }
        Element element = document.getDocumentElement();
        if (namespaceResolver.getDefaultNamespaceURI() != null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceResolver.getDefaultNamespaceURI());
        }
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = namespaceResolver.resolveNamespacePrefix(string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
    }

    public void buildAttributesIntoObject(Object object, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, JoinedAttributeManager joinedAttributeManager, boolean bl) throws DatabaseException {
        ((XMLRecord)abstractRecord).setSession(objectBuildingQuery.getSession().getExecutionSession(objectBuildingQuery));
        super.buildAttributesIntoObject(object, abstractRecord, objectBuildingQuery, joinedAttributeManager, bl);
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        AbstractRecord abstractRecord2 = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        expression.getBuilder().setSession(abstractSession.getRootSession(null));
        boolean bl = expression.extractPrimaryKeyValues(true, this.getDescriptor(), abstractRecord2, abstractRecord);
        if (!bl) {
            return null;
        }
        if (abstractRecord2.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return abstractRecord2;
    }

    public Vector extractPrimaryKeyFromExpression(boolean bl, Expression expression, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        AbstractRecord abstractRecord2 = this.createRecord(this.getPrimaryKeyMappings().size(), abstractSession);
        expression.getBuilder().setSession(abstractSession.getRootSession(null));
        boolean bl2 = expression.extractPrimaryKeyValues(bl, this.getDescriptor(), abstractRecord2, abstractRecord);
        if (bl && !bl2) {
            return null;
        }
        if (abstractRecord2.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(abstractRecord2, abstractSession);
    }

    public Vector extractPrimaryKeyFromObject(Object object, AbstractSession abstractSession) {
        if (this.getDescriptor().hasInheritance() && object.getClass() != this.getDescriptor().getJavaClass() && !object.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return abstractSession.getDescriptor(object).getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession);
        }
        if (this.getDescriptor().getPrimaryKeyFields().size() == 0) {
            return null;
        }
        return super.extractPrimaryKeyFromObject(object, abstractSession);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        return this.buildIntoNestedRow(abstractRecord, object, abstractSession, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession, boolean bl) {
        XMLDescriptor xMLDescriptor;
        XMLRecord xMLRecord = (XMLRecord)abstractRecord;
        xMLRecord.setSession(abstractSession);
        XMLMarshaller xMLMarshaller = xMLRecord.getMarshaller();
        if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
            xMLMarshaller.getMarshalListener().beforeMarshal(object);
        }
        List list = null;
        if (this.isXmlDescriptor()) {
            xMLDescriptor = (XMLDescriptor)this.getDescriptor();
            list = this.addExtraNamespacesToNamespaceResolver(xMLDescriptor, xMLRecord, abstractSession);
            this.writeExtraNamespaces(list, xMLRecord);
        }
        this.writeOutMappings(xMLRecord, object, abstractSession);
        if (this.isXmlDescriptor()) {
            xMLDescriptor = (XMLDescriptor)this.getDescriptor();
            XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
            if (bl) {
                this.writeXsiTypeAttribute(xMLDescriptor, (DOMRecord)xMLRecord, xMLSchemaReference.getSchemaContext().substring(1));
            }
            if (this.getDescriptor().hasInheritance()) {
                if (xMLRecord.getLeafElementType() != null && xMLSchemaReference.getType() == 1 && xMLSchemaReference.isGlobalDefinition()) {
                    QName qName = xMLSchemaReference.getSchemaContextAsQName(xMLDescriptor.getNamespaceResolver());
                    if (!qName.equals(xMLRecord.getLeafElementType())) {
                        XMLField xMLField = (XMLField)xMLDescriptor.getInheritancePolicy().getClassIndicatorField();
                        if (xMLField.getLastXPathFragment().isAttribute()) {
                            this.writeXsiTypeAttribute(xMLDescriptor, (DOMRecord)xMLRecord, xMLSchemaReference.getSchemaContext().substring(1));
                        } else {
                            this.writeXsiTypeAttribute(xMLDescriptor, (DOMRecord)xMLRecord, xMLSchemaReference.getSchemaContext().substring(1));
                        }
                    }
                } else if (!xMLDescriptor.getInheritancePolicy().hasClassExtractor()) {
                    XMLField xMLField = (XMLField)xMLDescriptor.getInheritancePolicy().getClassIndicatorField();
                    if (xMLField.getLastXPathFragment().isAttribute()) {
                        this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
                    } else {
                        this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(abstractRecord);
                    }
                }
            }
            this.removeExtraNamespacesFromNamespaceResolver(xMLRecord, list, abstractSession);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(abstractRecord);
        }
        if (xMLMarshaller != null && xMLMarshaller.getMarshalListener() != null) {
            xMLMarshaller.getMarshalListener().afterMarshal(object);
        }
        return abstractRecord;
    }

    private void writeXsiTypeAttribute(XMLDescriptor xMLDescriptor, DOMRecord dOMRecord, String string) {
        String string2 = null;
        boolean bl = false;
        string2 = dOMRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        if (string2 == null) {
            string2 = xMLDescriptor.getNonNullNamespaceResolver().generatePrefix("xsi");
            bl = true;
            this.writeXsiNamespace(dOMRecord, string2);
        }
        XMLField xMLField = (XMLField)xMLDescriptor.buildField("@" + string2 + ":" + "type");
        if (bl) {
            xMLField.getLastXPathFragment().setGeneratedPrefix(true);
        }
        xMLField.getLastXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        dOMRecord.add(xMLField, string);
    }

    private void writeXsiNamespace(DOMRecord dOMRecord, String string) {
        if (dOMRecord.getDOM().getNodeType() == 1) {
            ((Element)dOMRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public NamespaceResolver getNamespaceResolver() {
        NamespaceResolver namespaceResolver = null;
        if (this.isXmlDescriptor()) {
            namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        } else if (this.getDescriptor() instanceof EISDescriptor) {
            namespaceResolver = ((EISDescriptor)this.getDescriptor()).getNamespaceResolver();
        }
        return namespaceResolver;
    }

    protected boolean isXmlDescriptor() {
        if (this.isXMLDescriptor == null) {
            this.isXMLDescriptor = this.getDescriptor() instanceof XMLDescriptor;
        }
        return this.isXMLDescriptor;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        super.setDescriptor(classDescriptor);
        this.isXMLDescriptor = null;
    }

    protected List addExtraNamespacesToNamespaceResolver(XMLDescriptor xMLDescriptor, XMLRecord xMLRecord, AbstractSession abstractSession) {
        if (((XMLLogin)abstractSession.getDatasourceLogin()).hasEqualNamespaceResolvers()) {
            return null;
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        Vector vector = xMLDescriptor.getNonNullNamespaceResolver().getNamespaces();
        for (int i = 0; i < vector.size(); ++i) {
            Namespace namespace = (Namespace)vector.get(i);
            String string = xMLRecord.getNamespaceResolver().resolveNamespaceURI(namespace.getNamespaceURI());
            if (string == null || string.equals("")) {
                xMLRecord.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
                arrayList.add(namespace);
                continue;
            }
            if (string.equals(namespace.getPrefix())) continue;
            xMLRecord.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
            arrayList.add(namespace);
        }
        return arrayList;
    }

    public void writeExtraNamespaces(List list, XMLRecord xMLRecord) {
        if (list == null) {
            return;
        }
        if (xMLRecord.getDOM().getNodeType() != 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            ((Element)xMLRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public void removeExtraNamespacesFromNamespaceResolver(XMLRecord xMLRecord, List list, AbstractSession abstractSession) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            String string = xMLRecord.getNamespaceResolver().resolveNamespacePrefix(namespace.getPrefix());
            if (string == null || !string.equals(namespace.getNamespaceURI())) continue;
            xMLRecord.getNamespaceResolver().removeNamespace(namespace.getPrefix());
        }
    }
}

