/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.util.Map;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class ReplaceValueHoldersIterator
extends DescriptorIterator {
    RemoteSessionController controller;

    private ReplaceValueHoldersIterator() {
    }

    public ReplaceValueHoldersIterator(RemoteSessionController remoteSessionController) {
        this();
        this.initialize(remoteSessionController);
    }

    protected ObjectDescriptor buildObjectDescriptor(Object object) {
        return this.controller.buildObjectDescriptor(object);
    }

    protected RemoteValueHolder buildRemoteValueHolderFor(ValueHolderInterface valueHolderInterface) {
        RemoteValueHolder remoteValueHolder = null;
        if (valueHolderInterface instanceof RemoteValueHolder) {
            remoteValueHolder = (RemoteValueHolder)valueHolderInterface;
        } else {
            remoteValueHolder = new RemoteValueHolder();
            remoteValueHolder.setWrappedServerValueHolder(valueHolderInterface);
            remoteValueHolder.setMapping(this.getCurrentMapping());
        }
        this.saveRemoteValueHolder(remoteValueHolder);
        return remoteValueHolder;
    }

    protected void initialize(RemoteSessionController remoteSessionController) {
        this.controller = remoteSessionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalIterateIndirectContainer(IndirectContainer indirectContainer) {
        ValueHolderInterface valueHolderInterface = indirectContainer.getValueHolder();
        if (valueHolderInterface instanceof RemoteValueHolder) {
            valueHolderInterface = ((RemoteValueHolder)valueHolderInterface).getWrappedServerValueHolder();
        }
        ValueHolderInterface valueHolderInterface2 = valueHolderInterface;
        synchronized (valueHolderInterface2) {
            ValueHolderInterface valueHolderInterface3 = indirectContainer.getValueHolder();
            RemoteValueHolder remoteValueHolder = this.buildRemoteValueHolderFor(valueHolderInterface3);
            indirectContainer.setValueHolder(remoteValueHolder);
            remoteValueHolder.setServerIndirectionObject(indirectContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalIterateValueHolder(ValueHolderInterface valueHolderInterface) {
        ValueHolderInterface valueHolderInterface2 = valueHolderInterface;
        if (valueHolderInterface2 instanceof RemoteValueHolder) {
            valueHolderInterface2 = ((RemoteValueHolder)valueHolderInterface2).getWrappedServerValueHolder();
        }
        ValueHolderInterface valueHolderInterface3 = valueHolderInterface2;
        synchronized (valueHolderInterface3) {
            ValueHolderInterface valueHolderInterface4 = (ValueHolderInterface)this.getCurrentMapping().getAttributeValueFromObject(this.getVisitedParent());
            RemoteValueHolder remoteValueHolder = this.buildRemoteValueHolderFor(valueHolderInterface4);
            if (valueHolderInterface4 != remoteValueHolder) {
                if (this.getCurrentMapping().isOneToOneMapping()) {
                    this.setOneToOneMappingSettingsIn(remoteValueHolder);
                }
                this.getCurrentMapping().setAttributeValueInObject(this.getVisitedParent(), remoteValueHolder);
            }
        }
    }

    protected void iterate(Object object) {
        ((Map)this.getResult()).put(object, this.buildObjectDescriptor(object));
    }

    protected void saveRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        this.controller.saveRemoteValueHolder(remoteValueHolder);
    }

    protected void setOneToOneMappingSettingsIn(RemoteValueHolder remoteValueHolder) {
        ObjectReferenceMapping objectReferenceMapping = (ObjectReferenceMapping)this.getCurrentMapping();
        if (objectReferenceMapping.getDescriptor().getObjectBuilder().isPrimaryKeyMapping(objectReferenceMapping)) {
            remoteValueHolder.setRow(objectReferenceMapping.extractPrimaryKeyRowForSourceObject(this.getVisitedParent(), this.getSession()));
        }
        remoteValueHolder.setTargetObjectPrimaryKeys(objectReferenceMapping.extractPrimaryKeysForReferenceObject(this.getVisitedParent(), this.getSession()));
    }
}

