/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCollectionMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeyToSourceKeys = new HashMap<DatabaseField, DatabaseField>(5);
    protected transient Map<String, String> aggregateToSourceFieldNames;
    protected transient Map<String, Map<String, String>> nestedAggregateToSourceFieldNames;
    protected ClassDescriptor remoteReferenceDescriptor;

    public AggregateCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
        this.setCascadeAll(true);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addFieldNameTranslation(String string, String string2) {
        if (this.aggregateToSourceFieldNames == null) {
            this.aggregateToSourceFieldNames = new HashMap<String, String>(5);
        }
        this.aggregateToSourceFieldNames.put(string2, string);
    }

    public void addFieldNameTranslations(Map<String, String> map) {
        if (this.aggregateToSourceFieldNames == null) {
            this.aggregateToSourceFieldNames = map;
        } else {
            this.aggregateToSourceFieldNames.putAll(map);
        }
    }

    public void addNestedFieldNameTranslation(String string, String string2, String string3) {
        Map<String, String> map;
        if (this.nestedAggregateToSourceFieldNames == null) {
            this.nestedAggregateToSourceFieldNames = new HashMap<String, Map<String, String>>(5);
        }
        if ((map = this.nestedAggregateToSourceFieldNames.get(string)) == null) {
            map = new HashMap<String, String>(5);
            this.nestedAggregateToSourceFieldNames.put(string, map);
        }
        map.put(string3, string2);
    }

    public void addNestedFieldNameTranslations(String string, Map<String, String> map) {
        Map<String, String> map2;
        if (this.nestedAggregateToSourceFieldNames == null) {
            this.nestedAggregateToSourceFieldNames = new HashMap<String, Map<String, String>>(5);
        }
        if ((map2 = this.nestedAggregateToSourceFieldNames.get(string)) == null) {
            this.nestedAggregateToSourceFieldNames.put(string, map);
        } else {
            map2.putAll(map);
        }
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(string));
        this.getSourceKeyFields().addElement(new DatabaseField(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance(1);
        }
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object5 = object;
        synchronized (object5) {
            Object object6 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object6)) {
                Object object7 = this.buildElementBackupClone(containerPolicy.next(object6, unitOfWorkImpl), unitOfWorkImpl);
                containerPolicy.addInto(object7, object4, unitOfWorkImpl);
            }
        }
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance(1);
        }
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object5 = null;
        Object object6 = object;
        synchronized (object6) {
            object5 = containerPolicy.cloneFor(object);
        }
        object6 = containerPolicy.iteratorFor(object5);
        while (containerPolicy.hasNext(object6)) {
            Object object7 = containerPolicy.next(object6, unitOfWorkImpl);
            if (unitOfWorkImpl.isOriginalNewObject(object2)) {
                unitOfWorkImpl.addNewAggregate(object7);
            }
            Object object8 = this.buildElementClone(object7, unitOfWorkImpl, bl);
            containerPolicy.addInto(object8, object4, unitOfWorkImpl);
        }
        return object4;
    }

    protected Object buildElementBackupClone(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (unitOfWorkImpl.isClassReadOnly(object.getClass(), this.getReferenceDescriptor())) {
            return object;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object.getClass(), unitOfWorkImpl);
        Object object2 = classDescriptor.getObjectBuilder().buildBackupClone(object, unitOfWorkImpl);
        return object2;
    }

    @Override
    protected Object buildElementClone(Object object, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        if (unitOfWorkImpl.isClassReadOnly(object.getClass(), this.getReferenceDescriptor())) {
            return object;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object.getClass(), unitOfWorkImpl);
        Object object2 = classDescriptor.getObjectBuilder().instantiateWorkingCopyClone(object, unitOfWorkImpl);
        classDescriptor.getObjectBuilder().populateAttributesForClone(object, object2, unitOfWorkImpl);
        unitOfWorkImpl.getCloneToOriginals().put(object2, object);
        return object2;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null || !this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            return;
        }
        ObjectBuilder objectBuilder = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null) continue;
            objectBuilder = this.getReferenceDescriptor(object5.getClass(), unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeDiscoverAndPersistUnregisteredNewObjects(object5, map, map2, map3, unitOfWorkImpl);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null || !this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            return;
        }
        ObjectBuilder objectBuilder = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null || map.containsKey(object5)) continue;
            map.put(object5, object5);
            objectBuilder = this.getReferenceDescriptor(object5.getClass(), unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object5, unitOfWorkImpl, map);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ObjectBuilder objectBuilder = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null || map.containsKey(object5)) continue;
            map.put(object5, object5);
            objectBuilder = this.getReferenceDescriptor(object5.getClass(), unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object5, unitOfWorkImpl, map);
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 != null && this.getIndirectionPolicy().objectIsInstantiated(object2)) {
            Object object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object4 = containerPolicy.iteratorFor(object3);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
                if (object5 == null || map.containsKey(object5)) continue;
                map.put(object5, object5);
                ObjectBuilder objectBuilder = this.getReferenceDescriptor(object5.getClass(), unitOfWorkImpl).getObjectBuilder();
                objectBuilder.cascadePerformRemovePrivateOwnedObjectFromChangeSet(object5, unitOfWorkImpl, map);
            }
        }
    }

    @Override
    public Object clone() {
        AggregateCollectionMapping aggregateCollectionMapping = (AggregateCollectionMapping)super.clone();
        aggregateCollectionMapping.setTargetForeignKeyToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeyToSourceKeys()));
        aggregateCollectionMapping.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getSourceKeyFields()));
        aggregateCollectionMapping.setTargetForeignKeyFields(NonSynchronizedVector.newInstance(this.getTargetForeignKeyFields()));
        return aggregateCollectionMapping;
    }

    @Override
    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object4 == null && object3 == null) {
                return null;
            }
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object5 = null;
            Object object6 = null;
            object6 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            object5 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
            if (containerPolicy.sizeFor(object5) != containerPolicy.sizeFor(object6)) {
                return this.convertToChangeRecord(object6, objectChangeSet, abstractSession);
            }
            Object object7 = containerPolicy.iteratorFor(object6);
            Object object8 = containerPolicy.iteratorFor(object5);
            boolean bl = false;
            UnitOfWorkChangeSet unitOfWorkChangeSet = new UnitOfWorkChangeSet(abstractSession);
            while (containerPolicy.hasNext(object7)) {
                Object object9 = containerPolicy.next(object7, abstractSession);
                if (object9 == null) {
                    bl = true;
                    break;
                }
                Object object10 = null;
                if (!containerPolicy.hasNext(object8)) {
                    bl = true;
                    break;
                }
                object10 = containerPolicy.next(object8, abstractSession);
                if (object9.getClass().equals(object10.getClass())) {
                    ObjectBuilder objectBuilder = this.getReferenceDescriptor(object9.getClass(), abstractSession).getObjectBuilder();
                    ObjectChangeSet objectChangeSet2 = objectBuilder.createObjectChangeSet(object9, unitOfWorkChangeSet, objectChangeSet.isNew(), abstractSession);
                    ObjectChangeSet objectChangeSet3 = objectBuilder.compareForChange(object9, object10, unitOfWorkChangeSet, abstractSession);
                    if (objectChangeSet3 == null) continue;
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (bl || containerPolicy.hasNext(object8)) {
                return this.convertToChangeRecord(object6, objectChangeSet, abstractSession);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(object, abstractSession), objectChangeSet, abstractSession);
    }

    @Override
    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object3) != containerPolicy.sizeFor(object4)) {
            return false;
        }
        if (containerPolicy.sizeFor(object3) == 0) {
            return true;
        }
        Object object5 = containerPolicy.iteratorFor(object3);
        block0: while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, abstractSession);
            Object object7 = containerPolicy.iteratorFor(object4);
            do {
                Object object8 = containerPolicy.next(object7, abstractSession);
                if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(object6, object8, abstractSession)) continue block0;
            } while (containerPolicy.hasNext(object7));
            return false;
        }
        return true;
    }

    protected ChangeRecord convertToChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object2;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = containerPolicy.iteratorFor(object);
        Vector<ObjectChangeSet> vector = new Vector<ObjectChangeSet>(2);
        while (containerPolicy.hasNext(object3)) {
            object2 = containerPolicy.next(object3, abstractSession);
            if (object2 == null) continue;
            ObjectChangeSet objectChangeSet2 = this.getReferenceDescriptor(object2.getClass(), abstractSession).getObjectBuilder().compareForChange(object2, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
            vector.addElement(objectChangeSet2);
        }
        object2 = new AggregateCollectionChangeRecord(objectChangeSet);
        ((ChangeRecord)object2).setAttribute(this.getAttributeName());
        ((ChangeRecord)object2).setMapping(this);
        ((AggregateCollectionChangeRecord)object2).setChangedValues(vector);
        return object2;
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object, deleteObjectQuery.getSession()));
    }

    protected void executeEvent(int n, ObjectLevelModifyQuery objectLevelModifyQuery) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(objectLevelModifyQuery.getObject().getClass(), objectLevelModifyQuery.getSession());
        if (classDescriptor.getEventManager().hasAnyEventListeners()) {
            classDescriptor.getEventManager().executeEvent(new DescriptorEvent(n, objectLevelModifyQuery));
        }
    }

    protected Vector extractKeyFromTargetRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeyFields().size());
        for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getTargetForeignKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().elementAt(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readQuery;
        readAllQuery2.setShouldIncludeData(true);
        Enumeration<DatabaseField> enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            readAllQuery2.getAdditionalFields().addElement(enumeration.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable<CacheKey, Object> hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            containerPolicy = this.getContainerPolicy();
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            if (hashtable == null) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                ComplexQueryResult complexQueryResult = null;
                complexQueryResult = (ComplexQueryResult)abstractSession.executeQuery(databaseQuery, abstractRecord2);
                Object object = complexQueryResult.getResult();
                hashtable = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = ((Vector)complexQueryResult.getData()).elements();
                ContainerPolicy containerPolicy2 = readAllQuery.getContainerPolicy();
                Object object2 = containerPolicy2.iteratorFor(object);
                while (containerPolicy2.hasNext(object2)) {
                    Object object3 = containerPolicy2.next(object2, abstractSession);
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromTargetRow((AbstractRecord)enumeration.nextElement(), abstractSession));
                    if (!hashtable.containsKey(cacheKey)) {
                        hashtable.put(cacheKey, containerPolicy.containerInstance());
                    }
                    containerPolicy.addInto(object3, hashtable.get(cacheKey), abstractSession);
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    public AbstractRecord getAggregateRow(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        Vector vector = this.getReferenceObjectKeys(objectLevelModifyQuery);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Vector<DatabaseField> vector2 = this.getTargetForeignKeyFields();
        for (int i = 0; i < vector2.size(); ++i) {
            ((AbstractRecord)databaseRecord).put((Object)vector2.elementAt(i), vector.elementAt(i));
        }
        this.getReferenceDescriptor(object.getClass(), objectLevelModifyQuery.getSession()).getObjectBuilder().buildRow(databaseRecord, object, objectLevelModifyQuery.getSession());
        return databaseRecord;
    }

    protected Expression getDeleteAllCriteria(AbstractSession abstractSession) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField databaseField2 = this.getTargetForeignKeyToSourceKeys().get(databaseField);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            this.referenceDescriptor = this.remoteReferenceDescriptor;
        }
        return this.referenceDescriptor;
    }

    public ClassDescriptor getReferenceDescriptor(Class clazz, AbstractSession abstractSession) {
        if (this.getReferenceDescriptor().getJavaClass().equals(clazz)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor().getInheritancePolicy().getSubclassDescriptor(clazz);
        if (classDescriptor == null) {
            throw DescriptorException.noSubClassMatch(clazz, this);
        }
        return classDescriptor;
    }

    public Vector getReferenceObjectKeys(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException, OptimisticLockException {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        AbstractRecord abstractRecord = objectLevelModifyQuery.getTranslationRow();
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            Object object = null;
            object = abstractRecord != null && abstractRecord.containsKey(databaseField) ? abstractRecord.get(databaseField) : this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(objectLevelModifyQuery.getObject(), databaseField, objectLevelModifyQuery.getSession());
            vector.addElement(object);
        }
        return vector;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeyToSourceKeys() {
        return this.targetForeignKeyToSourceKeys;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (!this.getReferenceDescriptor().isAggregateCollectionDescriptor()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(this.getReferenceClass().getName(), this));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.isSourceKeySpecified()) {
                this.initializeTargetForeignKeyToSourceKeys(abstractSession);
            } else {
                this.initializeTargetForeignKeyToSourceKeysWithDefaults(abstractSession);
            }
            this.initializeSelectionCriteria(abstractSession);
        }
        this.getSelectionQuery().setShouldMaintainCache(false);
        this.initializeDeleteAllQuery(abstractSession);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession abstractSession) throws DescriptorException {
        Cloneable cloneable;
        super.initializeReferenceDescriptor(abstractSession);
        HashMap<DatabaseField, DatabaseField> hashMap = null;
        HashMap<DatabaseTable, DatabaseTable> hashMap2 = null;
        Object var4_4 = null;
        int n = 0;
        if (this.getReferenceDescriptor().getTables() != null) {
            n = this.getReferenceDescriptor().getTables().size();
        }
        if (this.aggregateToSourceFieldNames != null) {
            cloneable = null;
            cloneable = n != 0 ? this.getReferenceDescriptor().getTables().get(0) : new DatabaseTable();
            hashMap2 = new HashMap<DatabaseTable, DatabaseTable>();
            hashMap = new HashMap<DatabaseField, DatabaseField>();
            for (Map.Entry entry : this.aggregateToSourceFieldNames.entrySet()) {
                DatabaseField databaseField;
                DatabaseField databaseField2 = new DatabaseField((String)entry.getKey());
                if (!databaseField2.hasTableName()) {
                    databaseField2.setTable((DatabaseTable)cloneable);
                }
                if (!(databaseField = new DatabaseField((String)entry.getValue())).hasTableName()) {
                    // empty if block
                }
                DatabaseTable databaseTable = databaseField.getTable();
                DatabaseTable databaseTable2 = hashMap2.get(databaseField2.getTable());
                if (databaseTable2 == null) {
                    hashMap2.put(databaseField2.getTable(), databaseTable);
                } else if (!databaseTable.equals(databaseTable2)) {
                    // empty if block
                }
                hashMap.put(databaseField2, databaseField);
            }
        } else if (n == 0) {
            // empty if block
        }
        cloneable = (ClassDescriptor)this.getReferenceDescriptor().clone();
        if (hashMap != null) {
            AggregateCollectionMapping.translateTablesAndFields((ClassDescriptor)cloneable, hashMap, hashMap2);
        }
        if (this.nestedAggregateToSourceFieldNames != null) {
            this.updateNestedAggregateCollectionMappings((ClassDescriptor)cloneable);
        }
        if (((ClassDescriptor)cloneable).isChildDescriptor()) {
            ClassDescriptor classDescriptor = abstractSession.getDescriptor(((ClassDescriptor)cloneable).getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(classDescriptor, (ClassDescriptor)cloneable, abstractSession, hashMap, hashMap2);
        }
        if (((ClassDescriptor)cloneable).isAggregateDescriptor()) {
            ((ClassDescriptor)cloneable).descriptorIsAggregateCollection();
        }
        this.setReferenceDescriptor((ClassDescriptor)cloneable);
        ((ClassDescriptor)cloneable).preInitialize(abstractSession);
        ((ClassDescriptor)cloneable).initialize(abstractSession);
        if (((ClassDescriptor)cloneable).hasInheritance() && ((ClassDescriptor)cloneable).getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance((ClassDescriptor)cloneable, abstractSession, hashMap, hashMap2);
        }
    }

    protected static void translateTablesAndFields(ClassDescriptor classDescriptor, HashMap<DatabaseField, DatabaseField> hashMap, HashMap<DatabaseTable, DatabaseTable> hashMap2) {
        Cloneable cloneable;
        int n = 0;
        if (classDescriptor.getTables() != null) {
            n = classDescriptor.getTables().size();
        }
        DatabaseTable databaseTable = null;
        if (n == 0) {
            databaseTable = new DatabaseTable();
            cloneable = hashMap2.get(databaseTable);
            if (cloneable == null) {
                // empty if block
            }
            classDescriptor.addTable((DatabaseTable)cloneable);
        } else {
            databaseTable = classDescriptor.getTables().get(0);
            cloneable = NonSynchronizedVector.newInstance(n);
            for (int i = 0; i < n; ++i) {
                DatabaseTable databaseTable2 = hashMap2.get(classDescriptor.getTables().get(i));
                if (databaseTable2 == null) {
                    // empty if block
                }
                if (((Vector)cloneable).contains(databaseTable2)) continue;
                ((Vector)cloneable).add(databaseTable2);
            }
            classDescriptor.setTables((Vector<DatabaseTable>)cloneable);
        }
        int n2 = 0;
        if (classDescriptor.getPrimaryKeyFields() != null) {
            n2 = classDescriptor.getPrimaryKeyFields().size();
        }
        if (n2 > 0) {
            ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(n2);
            for (int i = 0; i < n2; ++i) {
                DatabaseField databaseField;
                DatabaseField databaseField2 = classDescriptor.getPrimaryKeyFields().get(i);
                if (!databaseField2.hasTableName() && n > 0) {
                    databaseField2 = new DatabaseField(databaseField2.getName(), databaseTable);
                }
                if ((databaseField = hashMap.get(databaseField2)) == null) {
                    // empty if block
                }
                arrayList.add(databaseField);
            }
            classDescriptor.setPrimaryKeyFields(arrayList);
        }
        classDescriptor.getObjectBuilder().getFieldsMap().putAll(hashMap);
    }

    protected void updateNestedAggregateCollectionMappings(ClassDescriptor classDescriptor) {
        for (Map.Entry<String, Map<String, String>> entry : this.nestedAggregateToSourceFieldNames.entrySet()) {
            DatabaseMapping databaseMapping;
            String string = entry.getKey();
            String string2 = null;
            int n = string.indexOf(46);
            if (n >= 0) {
                string2 = string.substring(n + 1, string.length());
                string = string.substring(0, n);
            }
            if ((databaseMapping = classDescriptor.getMappingForAttributeName(string)) == null) continue;
            if (!databaseMapping.isAggregateCollectionMapping()) {
                // empty if block
            }
            AggregateCollectionMapping aggregateCollectionMapping = (AggregateCollectionMapping)databaseMapping;
            if (string2 == null) {
                aggregateCollectionMapping.addFieldNameTranslations(entry.getValue());
                continue;
            }
            aggregateCollectionMapping.addNestedFieldNameTranslations(string2, entry.getValue());
        }
    }

    protected void translateFields(ClassDescriptor classDescriptor, AbstractSession abstractSession) {
        if (this.aggregateToSourceFieldNames != null) {
            Enumeration<DatabaseField> enumeration = classDescriptor.getFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = enumeration.nextElement();
                String string = databaseField.getName();
                String string2 = this.aggregateToSourceFieldNames.get(string);
                if (string2 == null) continue;
                DatabaseField databaseField2 = new DatabaseField(string2);
                if (databaseField2.getName().equals(string2)) {
                    databaseField.setName(string2);
                    continue;
                }
                databaseField.setName(databaseField2.getName());
                databaseField.setTable(classDescriptor.getTable(databaseField2.getTable().getName()));
            }
            classDescriptor.rehashFieldDependancies(abstractSession);
        }
    }

    public void initializeChildInheritance(ClassDescriptor classDescriptor, AbstractSession abstractSession, HashMap<DatabaseField, DatabaseField> hashMap, HashMap<DatabaseTable, DatabaseTable> hashMap2) throws DescriptorException {
        if (classDescriptor.getInheritancePolicy().hasChildren()) {
            Vector vector = classDescriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)((ClassDescriptor)enumeration.nextElement()).clone();
                if (hashMap != null) {
                    AggregateCollectionMapping.translateTablesAndFields(classDescriptor2, hashMap, hashMap2);
                }
                if (this.nestedAggregateToSourceFieldNames != null) {
                    this.updateNestedAggregateCollectionMappings(classDescriptor2);
                }
                if (classDescriptor2.isAggregateDescriptor()) {
                    classDescriptor2.descriptorIsAggregateCollection();
                }
                if (!classDescriptor2.isAggregateCollectionDescriptor()) {
                    abstractSession.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(classDescriptor2.getJavaClass().getName(), this));
                }
                classDescriptor2.getInheritancePolicy().setParentDescriptor(classDescriptor);
                classDescriptor2.preInitialize(abstractSession);
                classDescriptor2.initialize(abstractSession);
                ((Vector)nonSynchronizedVector).addElement(classDescriptor2);
                this.initializeChildInheritance(classDescriptor2, abstractSession, hashMap, hashMap2);
            }
            classDescriptor.getInheritancePolicy().setChildDescriptors(nonSynchronizedVector);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession abstractSession) {
        DeleteAllQuery deleteAllQuery = (DeleteAllQuery)this.getDeleteAllQuery();
        deleteAllQuery.setReferenceClass(this.getReferenceClass());
        deleteAllQuery.setDescriptor(this.getReferenceDescriptor());
        deleteAllQuery.setShouldMaintainCache(false);
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                deleteAllQuery.setSelectionCriteria(this.getDeleteAllCriteria(abstractSession));
            } else {
                deleteAllQuery.setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    public void initializeParentInheritance(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, AbstractSession abstractSession, HashMap<DatabaseField, DatabaseField> hashMap, HashMap<DatabaseTable, DatabaseTable> hashMap2) throws DescriptorException {
        Cloneable cloneable;
        ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor.clone();
        if (classDescriptor3.isAggregateDescriptor()) {
            classDescriptor3.descriptorIsAggregateCollection();
        }
        if (!classDescriptor3.isAggregateCollectionDescriptor()) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregateCollection(classDescriptor.getJavaClass().getName(), this));
        }
        if (hashMap != null) {
            AggregateCollectionMapping.translateTablesAndFields(classDescriptor3, hashMap, hashMap2);
        }
        if (this.nestedAggregateToSourceFieldNames != null) {
            this.updateNestedAggregateCollectionMappings(classDescriptor3);
        }
        if (classDescriptor3.getInheritancePolicy().isChildDescriptor()) {
            cloneable = abstractSession.getDescriptor(classDescriptor3.getJavaClass());
            this.initializeParentInheritance((ClassDescriptor)cloneable, classDescriptor, abstractSession, hashMap, hashMap2);
        }
        cloneable = NonSynchronizedVector.newInstance(1);
        ((Vector)cloneable).addElement(classDescriptor2);
        classDescriptor3.getInheritancePolicy().setChildDescriptors((Vector)cloneable);
        classDescriptor3.preInitialize(abstractSession);
        classDescriptor3.initialize(abstractSession);
    }

    protected void initializeSelectionCriteria(AbstractSession abstractSession) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        for (DatabaseField databaseField : this.getTargetForeignKeyToSourceKeys().keySet()) {
            DatabaseField databaseField2 = this.getTargetForeignKeyToSourceKeys().get(databaseField);
            Expression expression = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            Expression expression2 = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(expression2);
        }
    }

    protected void initializeTargetForeignKeyToSourceKeys(AbstractSession abstractSession) throws DescriptorException {
        Object object;
        int n;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            object = this.getTargetForeignKeyFields().get(n);
            object = this.getReferenceDescriptor().buildField((DatabaseField)object);
            this.getTargetForeignKeyFields().set(n, (DatabaseField)object);
        }
        for (n = 0; n < this.getSourceKeyFields().size(); ++n) {
            object = this.getSourceKeyFields().get(n);
            object = this.getDescriptor().buildField((DatabaseField)object);
            this.getSourceKeyFields().set(n, (DatabaseField)object);
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Iterator<DatabaseField> iterator = this.getTargetForeignKeyFields().iterator();
        object = this.getSourceKeyFields().iterator();
        while (iterator.hasNext()) {
            this.getTargetForeignKeyToSourceKeys().put(iterator.next(), (DatabaseField)object.next());
        }
    }

    protected void initializeTargetForeignKeyToSourceKeysWithDefaults(AbstractSession abstractSession) throws DescriptorException {
        int n;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            throw DescriptorException.noTargetForeignKeysSpecified(this);
        }
        List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
        this.setSourceKeyFields(NonSynchronizedVector.newInstance(list));
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            DatabaseField databaseField = this.getTargetForeignKeyFields().get(n);
            databaseField = this.getReferenceDescriptor().buildField(databaseField);
            this.getTargetForeignKeyFields().set(n, databaseField);
        }
        if (this.getTargetForeignKeyFields().size() != list.size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            this.getTargetForeignKeyToSourceKeys().put(this.getTargetForeignKeyFields().get(n), list.get(n));
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator descriptorIterator, Object object) {
        if (object != null) {
            descriptorIterator.iterateForAggregateMapping(object, this, this.getReferenceDescriptor(object.getClass(), descriptorIterator.getSession()));
        }
    }

    @Override
    public boolean isAggregateCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        if (!this.isAttributeValueInstantiatedOrChanged(object)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        AbstractSession abstractSession = mergeManager.getSession();
        Object object3 = null;
        Object object4 = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            ClassDescriptor classDescriptor = this.getDescriptor();
            AbstractRecord abstractRecord = classDescriptor.getObjectBuilder().extractPrimaryKeyRowFromObject(object, abstractSession);
            Object object5 = this.getIndirectionPolicy().valueFromQuery(this.getSelectionQuery(), abstractRecord, abstractSession);
            this.setAttributeValueInObject(object, object5);
            return;
        }
        Vector vector = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        object3 = containerPolicy.containerInstance();
        ObjectChangeSet objectChangeSet = null;
        for (int i = 0; i < vector.size(); ++i) {
            objectChangeSet = (ObjectChangeSet)vector.elementAt(i);
            Class clazz = objectChangeSet.getClassType(abstractSession);
            object4 = objectChangeSet.getUnitOfWorkClone();
            Object object6 = ((UnitOfWorkImpl)mergeManager.getSession()).getCloneToOriginals().get(object4);
            if (object6 == null) {
                object6 = this.getReferenceDescriptor(clazz, abstractSession).getObjectBuilder().buildNewInstance();
            }
            this.getReferenceDescriptor(clazz, abstractSession).getObjectBuilder().mergeChangesIntoObject(object6, objectChangeSet, object4, mergeManager);
            containerPolicy.addInto(object6, object3, abstractSession);
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    @Override
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiatedOrChanged(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiatedOrChanged(object) : !this.isAttributeValueInstantiatedOrChanged(object2)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object3));
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, mergeManager.getSession());
            Object object7 = null;
            if (object6 == null) continue;
            object7 = this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(object7, true, object6, mergeManager);
            containerPolicy.addInto(object7, object4, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(object, object4);
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet) throws DatabaseException, OptimisticLockException {
        InsertObjectQuery insertObjectQuery = this.getAndPrepareModifyQueryForInsert(objectLevelModifyQuery, object);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)insertObjectQuery, insertObjectQuery.getTranslationRow());
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setIsExecutionClone(true);
        this.prepareModifyQueryForDelete(objectLevelModifyQuery, deleteObjectQuery, object);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)deleteObjectQuery, deleteObjectQuery.getTranslationRow());
    }

    @Override
    protected void objectUnchangedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, Hashtable hashtable, CacheKey cacheKey) throws DatabaseException, OptimisticLockException {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setIsExecutionClone(true);
        Object v = hashtable.get(cacheKey);
        updateObjectQuery.setBackupClone(v);
        this.prepareModifyQueryForUpdate(objectLevelModifyQuery, updateObjectQuery, object);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)updateObjectQuery, updateObjectQuery.getTranslationRow());
    }

    @Override
    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        super.postInitialize(abstractSession);
        this.getReferenceDescriptor().postInitialize(abstractSession);
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            InsertObjectQuery insertObjectQuery = this.getAndPrepareModifyQueryForInsert(writeObjectQuery, object3);
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)insertObjectQuery, insertObjectQuery.getTranslationRow());
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                Object object3 = containerPolicy.next(object2, deleteObjectQuery.getSession());
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                this.prepareModifyQueryForDelete(deleteObjectQuery, deleteObjectQuery2, object3);
                deleteObjectQuery.getSession().executeQuery((DatabaseQuery)deleteObjectQuery2, deleteObjectQuery2.getTranslationRow());
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.verifyDeleteForUpdate(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery, object);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isReadOnly()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            InsertObjectQuery insertObjectQuery = this.getAndPrepareModifyQueryForInsert(writeObjectQuery, object3);
            this.executeEvent(0, insertObjectQuery);
            this.executeEvent(4, insertObjectQuery);
            this.getReferenceDescriptor(object3.getClass(), writeObjectQuery.getSession()).getQueryManager().preInsert(insertObjectQuery);
        }
    }

    protected InsertObjectQuery getInsertObjectQuery(AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        InsertObjectQuery insertObjectQuery = classDescriptor.getQueryManager().getInsertQuery();
        if (insertObjectQuery == null) {
            insertObjectQuery = new InsertObjectQuery();
            classDescriptor.getQueryManager().setInsertQuery(insertObjectQuery);
        }
        if (insertObjectQuery.getModifyRow() == null) {
            DatabaseRecord databaseRecord = new DatabaseRecord();
            for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
                DatabaseField databaseField = this.getTargetForeignKeyFields().elementAt(i);
                databaseRecord.put(databaseField, (Object)null);
            }
            classDescriptor.getObjectBuilder().buildTemplateInsertRow(abstractSession, databaseRecord);
            insertObjectQuery.setModifyRow(databaseRecord);
        }
        return insertObjectQuery;
    }

    public InsertObjectQuery getAndPrepareModifyQueryForInsert(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) {
        AbstractSession abstractSession = objectLevelModifyQuery.getSession();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object.getClass(), abstractSession);
        InsertObjectQuery insertObjectQuery = this.getInsertObjectQuery(abstractSession, classDescriptor);
        insertObjectQuery.checkPrepare(abstractSession, insertObjectQuery.getModifyRow());
        InsertObjectQuery insertObjectQuery2 = (InsertObjectQuery)insertObjectQuery.clone();
        insertObjectQuery2.setObject(object);
        insertObjectQuery2.setDescriptor(classDescriptor);
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Vector vector = this.getReferenceObjectKeys(objectLevelModifyQuery);
        for (int i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
            databaseRecord.put(this.getTargetForeignKeyFields().elementAt(i), vector.elementAt(i));
        }
        insertObjectQuery2.setModifyRow(databaseRecord);
        insertObjectQuery2.setTranslationRow(databaseRecord);
        insertObjectQuery2.setSession(abstractSession);
        insertObjectQuery2.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        insertObjectQuery2.dontMaintainCache();
        if (abstractSession.isUnitOfWork()) {
            Object object2 = this.getReferenceDescriptor(object.getClass(), abstractSession).getObjectBuilder().buildNewInstance();
            insertObjectQuery2.setBackupClone(object2);
        }
        return insertObjectQuery2;
    }

    public void prepareModifyQueryForDelete(ObjectLevelModifyQuery objectLevelModifyQuery, ObjectLevelModifyQuery objectLevelModifyQuery2, Object object) {
        AbstractRecord abstractRecord = this.getAggregateRow(objectLevelModifyQuery, object);
        objectLevelModifyQuery2.setObject(object);
        objectLevelModifyQuery2.setDescriptor(this.getReferenceDescriptor(object.getClass(), objectLevelModifyQuery.getSession()));
        objectLevelModifyQuery2.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord, objectLevelModifyQuery.getSession()));
        objectLevelModifyQuery2.setModifyRow(abstractRecord);
        objectLevelModifyQuery2.setTranslationRow(abstractRecord);
        objectLevelModifyQuery2.setSession(objectLevelModifyQuery.getSession());
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            objectLevelModifyQuery2.setCascadePolicy(5);
        } else {
            objectLevelModifyQuery2.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        }
        objectLevelModifyQuery2.dontMaintainCache();
    }

    public void prepareModifyQueryForUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, ObjectLevelModifyQuery objectLevelModifyQuery2, Object object) {
        AbstractRecord abstractRecord = this.getAggregateRow(objectLevelModifyQuery, object);
        objectLevelModifyQuery2.setObject(object);
        objectLevelModifyQuery2.setDescriptor(this.getReferenceDescriptor(object.getClass(), objectLevelModifyQuery.getSession()));
        objectLevelModifyQuery2.setPrimaryKey(this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord, objectLevelModifyQuery.getSession()));
        objectLevelModifyQuery2.setTranslationRow(abstractRecord);
        objectLevelModifyQuery2.setSession(objectLevelModifyQuery.getSession());
        objectLevelModifyQuery2.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        objectLevelModifyQuery2.dontMaintainCache();
    }

    @Override
    protected void setReferenceDescriptor(ClassDescriptor classDescriptor) {
        this.remoteReferenceDescriptor = this.referenceDescriptor = classDescriptor;
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector<DatabaseField> vector) {
        this.sourceKeyFields = vector;
    }

    public void setTargetForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetForeignKeyFields(nonSynchronizedVector);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> vector) {
        this.targetForeignKeyFields = vector;
    }

    protected void setTargetForeignKeyToSourceKeys(Map<DatabaseField, DatabaseField> map) {
        this.targetForeignKeyToSourceKeys = map;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        return !this.isReadOnly();
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, abstractSession);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, abstractSession);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().add(object2);
        }
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, abstractSession);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, abstractSession);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().remove(object2);
        }
    }

    @Override
    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        abstractRecord = (AbstractRecord)abstractRecord.clone();
        int n = 0;
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            Object object = null;
            int n2 = abstractRecord.getFields().indexOf(databaseField);
            if (n2 == -1) {
                object = objectBuildingQuery.getTranslationRow().get(databaseField);
                abstractRecord.add(databaseField, object);
            } else {
                object = abstractRecord.getValues().elementAt(n2);
            }
            abstractRecord.add(this.getTargetForeignKeyFields().elementAt(n), object);
            ++n;
        }
        return super.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord abstractRecord = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, abstractSession);
        Object object2 = abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), abstractRecord);
        return this.getContainerPolicy().isEmpty(object2);
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    @Override
    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "addToCollectionChangeRecord");
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return false;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        throw DescriptorException.invalidMappingOperation(this, "removeFromCollectionChangeRecord");
    }

    @Override
    public void remoteInitialization(DistributedSession distributedSession) {
        super.remoteInitialization(distributedSession);
        this.getReferenceDescriptor().remoteInitialization(distributedSession);
    }
}

