/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.querykeys;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

public class ManyToManyQueryKey
extends ForeignReferenceQueryKey {
    public boolean isCollectionQueryKey() {
        return true;
    }

    public boolean isManyToManyQueryKey() {
        return true;
    }

    public DatabaseTable getRelationTable(ClassDescriptor classDescriptor) {
        ExpressionIterator expressionIterator = new ExpressionIterator(){

            public void iterate(Expression expression) {
                DatabaseField databaseField;
                if (expression.isTableExpression()) {
                    ((Collection)this.getResult()).add(((TableExpression)expression).getTable());
                } else if (expression.isDataExpression()) {
                    DatabaseField databaseField2 = ((DataExpression)expression).getField();
                    if (databaseField2 != null && databaseField2.hasTableName()) {
                        ((Collection)this.getResult()).add(databaseField2.getTable());
                    }
                } else if (expression.isParameterExpression() && (databaseField = ((ParameterExpression)expression).getField()) != null && databaseField.hasTableName()) {
                    ((Collection)this.getResult()).add(databaseField.getTable());
                }
            }
        };
        expressionIterator.setResult(new HashSet());
        expressionIterator.iterateOn(this.joinCriteria);
        HashSet hashSet = (HashSet)expressionIterator.getResult();
        DatabaseTable databaseTable = null;
        for (DatabaseTable databaseTable2 : hashSet) {
            if (this.descriptor.getTables().contains(databaseTable2) || classDescriptor.getTables().contains(databaseTable2)) continue;
            databaseTable = databaseTable2;
            break;
        }
        if (databaseTable != null) {
            return databaseTable;
        }
        throw QueryException.noRelationTableInManyToManyQueryKey(this, this.joinCriteria);
    }
}

