/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class ReferenceMapping
extends ObjectReferenceMapping {
    protected DatabaseField field;

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        return null;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        this.setReferenceDescriptor(abstractSession.getDescriptor(this.getReferenceClass()));
        if (this.referenceDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)this.getField();
        objectRelationalDatabaseField.setSqlType(2006);
        if (this.referenceDescriptor instanceof ObjectRelationalDataTypeDescriptor) {
            objectRelationalDatabaseField.setSqlTypeName(((ObjectRelationalDataTypeDescriptor)this.referenceDescriptor).getStructureName());
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        this.getDescriptor().setIsNativeConnectionRequired(true);
    }

    public boolean isReferenceMapping() {
        return true;
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
            insertObjectQuery.setIsExecutionClone(true);
            insertObjectQuery.setObject(object);
            insertObjectQuery.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(insertObjectQuery);
        } else {
            ObjectChangeSet objectChangeSet = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object);
            writeObjectQuery2.setObjectChangeSet(objectChangeSet);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (object = this.readPrivateOwnedForObject(writeObjectQuery)) != null) {
            writeObjectQuery.setProperty(this, object);
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object != null) {
            ObjectChangeSet objectChangeSet = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object);
            writeObjectQuery2.setObjectChangeSet(objectChangeSet);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setFieldName(String string) {
        this.setField(new ObjectRelationalDatabaseField(string));
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Struct struct;
        Object object;
        Ref ref = (Ref)abstractRecord.get(this.getField());
        if (ref == null) {
            return null;
        }
        try {
            ((DatabaseAccessor)abstractSession.getAccessor()).incrementCallCount(abstractSession);
            object = ((DatabaseAccessor)abstractSession.getAccessor()).getConnection();
            struct = (Struct)abstractSession.getPlatform().getRefValue(ref, abstractSession, (Connection)object);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, abstractSession, false);
        }
        object = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).buildRowFromStructure(struct);
        ((DatabaseAccessor)abstractSession.getAccessor()).decrementCallCount();
        return this.getReferenceDescriptor().getObjectBuilder().buildObject(objectBuildingQuery, (AbstractRecord)object, joinedAttributeManager);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (object2 == null) {
            abstractRecord.put(this.getField(), (Object)null);
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(object2, abstractSession);
        abstractRecord.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        Object object = objectChangeSet.getUnitOfWorkClone();
        if (object == null) {
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(object, abstractSession);
        abstractRecord.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }
}

