/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMapping
extends DatabaseMapping
implements XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<XMLField, String> fieldToClassNameMappings = new HashMap<XMLField, String>();
    private Map<XMLField, Converter> fieldsToConverters;
    private ContainerPolicy containerPolicy;

    public XMLChoiceCollectionMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.choiceElementMappings = new HashMap<XMLField, XMLMapping>();
        this.fieldsToConverters = new HashMap<XMLField, Converter>();
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
    }

    @Override
    public void buildBackupClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public void iterate(DescriptorIterator descriptorIterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
    }

    @Override
    public void writeSingleValue(Object object, Object object2, XMLRecord xMLRecord, AbstractSession abstractSession) {
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.getFieldToClassMappings().keySet());
        return vector;
    }

    public void addChoiceElement(String string, Class clazz) {
        XMLField xMLField = new XMLField(string);
        this.addChoiceElement(xMLField, clazz);
    }

    public void addChoiceElement(String string, String string2) {
        XMLField xMLField = new XMLField(string);
        this.fieldToClassNameMappings.put(xMLField, string2);
    }

    public void addChoiceElement(XMLField xMLField, Class clazz) {
        this.getFieldToClassMappings().put(xMLField, clazz);
        if (!this.fieldToClassNameMappings.containsKey(xMLField)) {
            this.fieldToClassNameMappings.put(xMLField, clazz.getName());
        }
        if (this.classToFieldMappings.get(clazz) == null) {
            this.classToFieldMappings.put(clazz, xMLField);
        }
    }

    public void addChoiceElement(XMLField xMLField, String string) {
        this.fieldToClassNameMappings.put(xMLField, string);
    }

    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.fieldToClassMappings.size() == 0) {
            this.convertClassNamesToClasses(((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).getLoader());
        }
        for (XMLField xMLField : this.getFieldToClassMappings().keySet()) {
            DatabaseMapping databaseMapping;
            Converter converter = null;
            if (this.fieldsToConverters != null) {
                converter = this.fieldsToConverters.get(xMLField);
            }
            if (xMLField.getLastXPathFragment().nameIsText()) {
                databaseMapping = new XMLCompositeDirectCollectionMapping();
                databaseMapping.setAttributeName(this.getAttributeName());
                databaseMapping.setAttributeAccessor(this.getAttributeAccessor());
                ((AbstractCompositeDirectCollectionMapping)databaseMapping).setAttributeElementClass(this.getFieldToClassMappings().get(xMLField));
                XMLConversionManager xMLConversionManager = (XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager();
                QName qName = (QName)xMLConversionManager.getDefaultJavaTypes().get(((AbstractCompositeDirectCollectionMapping)databaseMapping).getAttributeElementClass());
                if (qName != null) {
                    xMLField.setSchemaType(qName);
                }
                ((AbstractCompositeDirectCollectionMapping)databaseMapping).setField(xMLField);
                databaseMapping.setDescriptor(this.getDescriptor());
                ((AbstractCompositeDirectCollectionMapping)databaseMapping).setContainerPolicy(this.getContainerPolicy());
                if (converter != null) {
                    ((AbstractCompositeDirectCollectionMapping)databaseMapping).setValueConverter(converter);
                }
                this.choiceElementMappings.put(xMLField, (XMLMapping)((Object)databaseMapping));
                ((XMLCompositeDirectCollectionMapping)databaseMapping).initialize(abstractSession);
                continue;
            }
            databaseMapping = new XMLCompositeCollectionMapping();
            databaseMapping.setAttributeName(this.getAttributeName());
            databaseMapping.setAttributeAccessor(this.getAttributeAccessor());
            ((AggregateMapping)databaseMapping).setReferenceClass(this.getFieldToClassMappings().get(xMLField));
            ((AbstractCompositeCollectionMapping)databaseMapping).setField(xMLField);
            databaseMapping.setDescriptor(this.getDescriptor());
            ((AbstractCompositeCollectionMapping)databaseMapping).setContainerPolicy(this.getContainerPolicy());
            if (converter != null) {
                ((AbstractCompositeCollectionMapping)databaseMapping).setConverter(converter);
            }
            this.choiceElementMappings.put(xMLField, (XMLMapping)((Object)databaseMapping));
            ((XMLCompositeCollectionMapping)databaseMapping).initialize(abstractSession);
        }
    }

    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (XMLField xMLField : this.fieldToClassNameMappings.keySet()) {
            Class clazz;
            block6: {
                String string = this.fieldToClassNameMappings.get(xMLField);
                clazz = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(string, privilegedActionException.getException());
                        }
                    }
                    clazz = PrivilegedAccessHelper.getClassForName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(string, classNotFoundException);
                }
            }
            this.addChoiceElement(xMLField, clazz);
        }
    }

    public void addConverter(XMLField xMLField, Converter converter) {
        if (this.fieldsToConverters == null) {
            this.fieldsToConverters = new HashMap<XMLField, Converter>();
        }
        this.fieldsToConverters.put(xMLField, converter);
    }

    public ArrayList getChoiceFieldToClassAssociations() {
        ArrayList<XMLChoiceFieldToClassAssociation> arrayList = new ArrayList<XMLChoiceFieldToClassAssociation>();
        if (this.fieldToClassNameMappings.size() > 0) {
            for (XMLField xMLField : this.fieldToClassNameMappings.keySet()) {
                String string = this.fieldToClassNameMappings.get(xMLField);
                XMLChoiceFieldToClassAssociation xMLChoiceFieldToClassAssociation = new XMLChoiceFieldToClassAssociation(xMLField, string);
                arrayList.add(xMLChoiceFieldToClassAssociation);
            }
        }
        return arrayList;
    }

    public void setChoiceFieldToClassAssociations(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            for (Object e : arrayList) {
                XMLChoiceFieldToClassAssociation xMLChoiceFieldToClassAssociation = (XMLChoiceFieldToClassAssociation)e;
                this.addChoiceElement(xMLChoiceFieldToClassAssociation.getXmlField(), xMLChoiceFieldToClassAssociation.getClassName());
                if (xMLChoiceFieldToClassAssociation.getConverter() == null) continue;
                this.addConverter(xMLChoiceFieldToClassAssociation.getXmlField(), xMLChoiceFieldToClassAssociation.getConverter());
            }
        }
    }
}

