/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;

public class NativeSequence
extends QuerySequence {
    protected boolean shouldUseIdentityIfPlatformSupports = true;

    public NativeSequence() {
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(boolean bl) {
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(bl);
    }

    public NativeSequence(String string) {
        super(string);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String string, boolean bl) {
        super(string);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(bl);
    }

    public NativeSequence(String string, int n) {
        super(string, n);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String string, int n, boolean bl) {
        super(string, n);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(bl);
    }

    public NativeSequence(String string, int n, int n2) {
        super(string, n, n2);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String string, int n, int n2, boolean bl) {
        super(string, n, n2);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(bl);
    }

    public boolean isNative() {
        return true;
    }

    public void setShouldUseIdentityIfPlatformSupports(boolean bl) {
        this.shouldUseIdentityIfPlatformSupports = bl;
    }

    public boolean shouldUseIdentityIfPlatformSupports() {
        return this.shouldUseIdentityIfPlatformSupports;
    }

    public boolean equals(Object object) {
        if (object instanceof NativeSequence) {
            return NativeSequence.equalNameAndSize(this, (NativeSequence)object);
        }
        return false;
    }

    protected ValueReadQuery buildSelectQuery() {
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity();
        }
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject();
    }

    protected ValueReadQuery buildSelectQuery(String string, Integer n) {
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity(string, n);
        }
        return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject(string, n);
    }

    public void onConnect() {
        DatabasePlatform databasePlatform;
        block8: {
            databasePlatform = null;
            try {
                databasePlatform = (DatabasePlatform)this.getDatasourcePlatform();
            }
            catch (ClassCastException classCastException) {
                if (this.getSelectQuery() != null) break block8;
                throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
            }
        }
        if (!databasePlatform.supportsNativeSequenceNumbers() && this.getSelectQuery() == null) {
            throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
        }
        if (databasePlatform.supportsIdentity() && this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(true);
        } else if (databasePlatform.supportsSequenceObjects() && !this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(false);
        } else if (databasePlatform.supportsNativeSequenceNumbers()) {
            this.setShouldAcquireValueAfterInsert(databasePlatform.supportsIdentity());
        }
        this.setShouldUseTransaction(databasePlatform.shouldNativeSequenceUseTransaction());
        super.onConnect();
    }

    public void onDisconnect() {
        this.setShouldAcquireValueAfterInsert(false);
        this.setShouldUseTransaction(false);
        super.onDisconnect();
    }
}

