/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.Sequence;

public abstract class StandardSequence
extends Sequence {
    public StandardSequence() {
    }

    public StandardSequence(String string) {
        super(string);
    }

    public StandardSequence(String string, int n) {
        super(string, n);
    }

    public StandardSequence(String string, int n, int n2) {
        super(string, n, n2);
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected abstract Number updateAndSelectSequence(Accessor var1, AbstractSession var2, String var3, int var4);

    public abstract boolean shouldAcquireValueAfterInsert();

    public abstract boolean shouldUseTransaction();

    public Object getGeneratedValue(Accessor accessor, AbstractSession abstractSession, String string) {
        if (this.shouldUsePreallocation()) {
            return null;
        }
        Number number = this.updateAndSelectSequence(accessor, abstractSession, string, 1);
        if (number == null) {
            throw DatabaseException.errorPreallocatingSequenceNumbers();
        }
        return number;
    }

    public Vector getGeneratedVector(Accessor accessor, AbstractSession abstractSession, String string, int n) {
        if (this.shouldUsePreallocation()) {
            Number number = this.updateAndSelectSequence(accessor, abstractSession, string, n);
            if (number == null) {
                throw DatabaseException.errorPreallocatingSequenceNumbers();
            }
            return this.createVector(number, string, n);
        }
        return null;
    }

    protected Vector createVector(Number number, String string, int n) {
        long l = number.longValue();
        Vector<Long> vector = new Vector<Long>(n);
        if ((l -= (long)n) < -1L) {
            throw ValidationException.sequenceSetupIncorrectly(string);
        }
        for (int i = n; i > 0; --i) {
            vector.add(++l);
        }
        return vector;
    }

    public void setInitialValue(int n) {
        if (n <= 0) {
            n = 1;
        }
        super.setInitialValue(n);
    }
}

