/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.sessions.factories.EclipseLinkObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceRuntimeXMLProject_11_1_1;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLProjectReader {
    protected static boolean shouldUseSchemaValidation = false;
    protected static Project project;
    public static final String SCHEMA_DIR = "xsd/";
    public static final String OPM_SCHEMA = "object-persistence_1_0.xsd";
    public static final String ECLIPSELINK_SCHEMA = "eclipselink_persistence_map_1.1.xsd";
    public static final String ECLIPSELINK_1_0_SCHEMA = "eclipselink_persistence_map_1.0.xsd";
    public static final String TOPLINK_11_SCHEMA = "toplink-object-persistence_11_1_1.xsd";
    public static final String TOPLINK_10_SCHEMA = "toplink-object-persistence_10_1_3.xsd";

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean bl) {
        shouldUseSchemaValidation = bl;
    }

    public static Project read(String string) {
        return XMLProjectReader.read(string, null);
    }

    public static Project read(Reader reader, ClassLoader classLoader) {
        Document document;
        Object object;
        try {
            StringWriter stringWriter = new StringWriter(4096);
            object = new char[4096];
            int n = 0;
            while ((n = reader.read((char[])object)) != -1) {
                stringWriter.write((char[])object, 0, n);
            }
            String string = null;
            if (XMLProjectReader.shouldUseSchemaValidation()) {
                string = "xsd/eclipselink_persistence_map_1.1.xsd";
            }
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            XMLParser xMLParser = XMLProjectReader.createXMLParser(xMLPlatform, true, false, string);
            try {
                document = xMLParser.parse(new StringReader(stringWriter.toString()));
            }
            catch (Exception exception) {
                try {
                    if (XMLProjectReader.shouldUseSchemaValidation()) {
                        string = "xsd/eclipselink_persistence_map_1.0.xsd";
                    }
                    xMLParser = XMLProjectReader.createXMLParser(xMLPlatform, true, false, string);
                    document = xMLParser.parse(new StringReader(stringWriter.toString()));
                }
                catch (Exception exception2) {
                    try {
                        if (XMLProjectReader.shouldUseSchemaValidation()) {
                            string = "xsd/toplink-object-persistence_11_1_1.xsd";
                        }
                        xMLParser = XMLProjectReader.createXMLParser(xMLPlatform, true, false, string);
                        document = xMLParser.parse(new StringReader(stringWriter.toString()));
                    }
                    catch (Exception exception3) {
                        throw exception;
                    }
                    String string2 = document.getDocumentElement().getAttribute("version");
                    if (string2 == null || string2.indexOf("1.0") == -1) {
                        throw exception;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw XMLMarshalException.unmarshalException(exception);
        }
        object = document.getDocumentElement().getAttribute("version");
        if (object != null && ((String)object).indexOf("10.1.3") != -1) {
            return XMLProjectReader.read1013Format(document, classLoader);
        }
        if (object != null && ((String)object).indexOf("11.1.1") != -1) {
            return XMLProjectReader.read1111Format(document, classLoader);
        }
        if (project == null) {
            project = new EclipseLinkObjectPersistenceRuntimeXMLProject();
        }
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, (Project)project.clone());
    }

    private static XMLParser createXMLParser(XMLPlatform xMLPlatform, boolean bl, boolean bl2, String string) {
        XMLParser xMLParser = xMLPlatform.newXMLParser();
        xMLParser.setNamespaceAware(bl);
        xMLParser.setWhitespacePreserving(bl2);
        if (string != null) {
            xMLParser.setValidationMode(3);
            XMLSchemaResolver xMLSchemaResolver = new XMLSchemaResolver();
            URL uRL = xMLSchemaResolver.resolveURL(string);
            xMLParser.setEntityResolver(xMLSchemaResolver);
            xMLParser.setXMLSchema(uRL);
        }
        return xMLParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project read(String string, ClassLoader classLoader) {
        Object object;
        if (string.toLowerCase().indexOf(".mwp") != -1) {
            throw ValidationException.invalidFileName(string);
        }
        InputStream inputStream = null;
        inputStream = classLoader == null ? new ConversionManager().getLoader().getResourceAsStream(string) : classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            object = new File(string);
            if (!((File)object).exists()) {
                throw ValidationException.projectXMLNotFound(string, null);
            }
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw ValidationException.projectXMLNotFound(string, fileNotFoundException);
            }
        }
        object = null;
        try {
            Project project;
            try {
                object = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ValidationException.fatalErrorOccurred(unsupportedEncodingException);
            }
            Project project2 = project = XMLProjectReader.read((Reader)object, classLoader);
            return project2;
        }
        finally {
            try {
                if (object != null) {
                    ((InputStreamReader)object).close();
                }
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        }
    }

    public static Project read1013Format(Document document, ClassLoader classLoader) {
        ObjectPersistenceRuntimeXMLProject objectPersistenceRuntimeXMLProject = new ObjectPersistenceRuntimeXMLProject();
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, objectPersistenceRuntimeXMLProject);
    }

    public static Project read1111Format(Document document, ClassLoader classLoader) {
        ObjectPersistenceRuntimeXMLProject_11_1_1 objectPersistenceRuntimeXMLProject_11_1_1 = new ObjectPersistenceRuntimeXMLProject_11_1_1();
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, objectPersistenceRuntimeXMLProject_11_1_1);
    }

    public static Project readObjectPersistenceRuntimeFormat(Document document, ClassLoader classLoader, Project project) {
        XMLLogin xMLLogin = new XMLLogin();
        xMLLogin.setDatasourcePlatform(new DOMPlatform());
        project.setDatasourceLogin(xMLLogin);
        if (classLoader != null) {
            xMLLogin.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
        XMLContext xMLContext = new XMLContext(project);
        xMLContext.getSession(Project.class).getEventManager().addListener(new MissingDescriptorListener());
        XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
        Project project2 = (Project)xMLUnmarshaller.unmarshal(document);
        if (classLoader != null && project2.getDatasourceLogin() != null) {
            project2.getDatasourceLogin().getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
        return project2;
    }

    public static Project read(Reader reader) {
        return XMLProjectReader.read(reader, null);
    }

    private static class XMLSchemaResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (XMLProjectReader.OPM_SCHEMA.equals(string2)) {
                URL uRL = this.resolveURL("xsd/object-persistence_1_0.xsd");
                if (null == uRL) {
                    return null;
                }
                return new InputSource(uRL.openStream());
            }
            return null;
        }

        public URL resolveURL(String string) {
            return this.getClass().getClassLoader().getResource(string);
        }
    }
}

