/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Member;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Sortable;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class Method
extends Member
implements Sortable {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int INOUT = 3;
    public static final int RETURN = 4;
    public static final int ALL = 0;
    protected Type m_returnType;
    protected Type[] m_paramTypes;
    protected String[] m_paramNames;
    protected int[] m_paramModes;
    protected boolean[] m_paramDefaults;
    protected boolean m_hasDefault;
    protected boolean m_keepMethodName = false;
    protected String m_overloadNumber;

    public Method(String name, String overloadNumber, int modifiers, Type returnType, Type[] parameterTypes, String[] parameterNames, int[] parameterModes, boolean[] parameterDefaults, int paramLen) {
        super(name, modifiers);
        this.m_returnType = returnType;
        this.m_overloadNumber = overloadNumber;
        if (paramLen > -1 && parameterTypes != null && parameterNames != null && parameterModes != null && parameterDefaults != null) {
            this.m_paramTypes = new Type[paramLen];
            this.m_paramNames = new String[paramLen];
            this.m_paramModes = new int[paramLen];
            this.m_paramDefaults = new boolean[paramLen];
            this.m_hasDefault = false;
            for (int i = 0; i < paramLen; ++i) {
                this.m_paramModes[i] = parameterModes[i];
                this.m_paramNames[i] = parameterNames[i];
                this.m_paramTypes[i] = parameterTypes[i];
                this.m_paramDefaults[i] = parameterDefaults[i];
                if (!this.m_paramDefaults[i]) continue;
                this.m_hasDefault = true;
            }
        }
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public String[] getParamNames() {
        return this.m_paramNames;
    }

    public Type[] getParamTypes() {
        return this.m_paramTypes;
    }

    public int[] getParamModes() {
        return this.m_paramModes;
    }

    public boolean[] getParamDefaults() {
        return this.m_paramDefaults;
    }

    public boolean hasDefault() {
        return this.m_hasDefault;
    }

    public String getSqlStatement() {
        return null;
    }

    public String toString() {
        String printout = this.m_returnType + " " + this.m_name + "(";
        for (int i = 0; i < this.m_paramTypes.length; ++i) {
            printout = printout + this.m_paramTypes[i].toString() + " " + this.m_paramNames[i].toString();
            if (i >= this.m_paramTypes.length - 1) continue;
            printout = printout + ",";
        }
        printout = printout + ");";
        return printout;
    }

    public boolean keepMethodName() {
        return this.m_keepMethodName;
    }

    public void setKeepMethodName(boolean keep) {
        this.m_keepMethodName = keep;
    }

    @Override
    public String getSortingKey() {
        int i;
        String key = this.m_name;
        if (this.m_overloadNumber != null) {
            for (i = 0; i < 6 - this.m_overloadNumber.length(); ++i) {
                key = key + "9";
            }
            key = key + this.m_overloadNumber;
        }
        for (i = 0; i < this.m_paramTypes.length; ++i) {
            if (i > 0) {
                key = key + ",";
            }
            key = key + this.m_paramTypes[i].getName();
        }
        return key;
    }
}

