/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllCollTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ElemInfo;

public class SqlCollectionType
extends SqlType {
    protected Type m_elementType;
    protected int m_elemTypeLength;
    protected int m_elemTypePrecision;
    protected int m_elemTypeScale;
    protected boolean m_isNChar;

    public SqlCollectionType(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) {
        super(sqlName, typecode, generateMe, parentType, reflector);
        ((JavaName)sqlName.getLangName()).ungenPattern(sqlName.getSimpleName());
    }

    public SqlCollectionType(SqlName sqlName, Type eleType, SqlReflector reflector) throws SQLException {
        super(sqlName, 1995, true, null, reflector);
        ((JavaName)sqlName.getLangName()).ungenPattern(sqlName.getSimpleName());
        this.m_elementType = eleType;
    }

    @Override
    public Type getComponentType() throws SQLException, PublisherException {
        if (this.m_elementType == null) {
            SqlType result;
            block4: {
                result = null;
                try {
                    ElemInfo scti = this.getElemInfo();
                    if (scti != null) {
                        String elemTypeName = scti.elemTypeName;
                        String elemSchemaName = scti.elemTypeOwner;
                        String elemTypeMod = scti.elemTypeMod;
                        this.m_elemTypeLength = scti.elemTypeLength;
                        this.m_elemTypePrecision = scti.elemTypePrecision;
                        this.m_elemTypeScale = scti.elemTypeScale;
                        result = this.m_reflector.addSqlDBType(elemSchemaName, elemTypeName, null, elemTypeMod, false, this);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (result != null) break block4;
                    result = SqlReflector.UNKNOWN_TYPE;
                }
            }
            this.m_elementType = result;
        }
        return this.m_elementType;
    }

    protected ElemInfo getElemInfo() throws SQLException {
        ElemInfo elemInfo = null;
        SqlName sqlName = this.getSqlName();
        String schema = sqlName.getSchemaName();
        String type = sqlName.getTypeName();
        Iterator scti = this.m_viewCache.getRows("ALL_COLL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{schema, type}, new String[0]);
        Object elemTypeName = null;
        Object elemTypeOwner = null;
        Object elemTypeMod = null;
        if (scti.hasNext()) {
            AllCollTypes viewRow = (AllCollTypes)scti.next();
            this.m_isNChar = "NCHAR_CS".equals(viewRow.characterSetName);
            elemInfo = new ElemInfo(viewRow);
            if (SqlReflector.isNull(elemInfo.elemTypeMod) && !SqlReflector.isNull(elemInfo.elemTypeName) && (scti = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{elemInfo.elemTypeOwner, elemInfo.elemTypeName}, new String[0])).hasNext()) {
                elemInfo.elemTypeMod = ((AllTypes)scti.next()).typeCode;
            }
        }
        return elemInfo;
    }

    public int getElemTypeLength() {
        return this.m_elemTypeLength;
    }

    public int getElemTypePrecision() {
        return this.m_elemTypePrecision;
    }

    public int getElemTypeScale() {
        return this.m_elemTypeScale;
    }

    public boolean isNChar() {
        return this.m_isNChar;
    }
}

