/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Field;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Map;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;

public abstract class SqlTypeWithFields
extends SqlType {
    protected Field[] m_fieldsPublishedOnly;
    protected Field[] m_fields;
    protected static HashMap m_builtin = new HashMap();

    public SqlTypeWithFields(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        super(sqlName, typecode, generateMe, parentType, reflector);
    }

    @Override
    public Field[] getDeclaredFields(boolean publishedOnly) throws SQLException, PublisherException {
        if (publishedOnly) {
            if (this.m_fieldsPublishedOnly == null) {
                this.m_fieldsPublishedOnly = this.reflectFields(publishedOnly);
            }
            return this.m_fieldsPublishedOnly;
        }
        if (this.m_fields == null) {
            this.m_fields = this.reflectFields(publishedOnly);
        }
        return this.m_fields;
    }

    private Field[] reflectFields(boolean publishedOnly) throws SQLException, PublisherException {
        return SqlTypeWithFields.reflectFields(publishedOnly, this.getFieldInfo(), this.m_reflector, this, false);
    }

    static Field[] reflectFields(boolean publishedOnly, FieldInfo[] sfi, SqlReflector reflector, SqlType parent, boolean isGrandparent) throws SQLException, PublisherException {
        ArrayList<Field> fieldsCS = new ArrayList<Field>();
        ViewCache viewCache = reflector.getViewCache();
        Map map = new Map(parent, reflector);
        for (int ii = 0; sfi != null && ii < sfi.length; ++ii) {
            try {
                Iterator iter;
                int idx = sfi[ii].fieldNo;
                if (publishedOnly && map.getMemberName(sfi[ii].fieldName) == null) continue;
                String fieldTypeOwner = sfi[ii].fieldTypeOwner;
                if (m_builtin.get(sfi[ii].fieldTypeName) == null && !(iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME", "PREDEFINED"}, new Object[]{fieldTypeOwner, sfi[ii].fieldTypeName, "NO"}, new String[0])).hasNext() && (iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"TYPE_NAME", "PREDEFINED"}, new Object[]{sfi[ii].fieldTypeName, "NO"}, new String[0])).hasNext()) {
                    fieldTypeOwner = ((AllTypes)iter.next()).owner;
                }
                fieldsCS.add(new Field(sfi[ii].fieldName, (Type)reflector.addPlsqlDBType(fieldTypeOwner, sfi[ii].fieldTypeName, sfi[ii].fieldTypeSubname, sfi[ii].fieldTypeMod, false, sfi[ii].fieldPackageName, sfi[ii].fieldMethodName, sfi[ii].fieldMethodNo, sfi[ii].fieldSequence, parent, isGrandparent), sfi[ii].fieldDataLength, sfi[ii].fieldDataPrecision, sfi[ii].fieldDataScale, sfi[ii].fieldCharacterSetName, reflector));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Field[] sqlFields = new Field[fieldsCS.size()];
        for (int i = 0; i < sqlFields.length; ++i) {
            sqlFields[i] = (Field)fieldsCS.get(i);
        }
        return sqlFields;
    }

    protected abstract FieldInfo[] getFieldInfo() throws SQLException;

    static {
        m_builtin.put("VARCHAR2", Boolean.TRUE);
        m_builtin.put("NUMBER", Boolean.TRUE);
        m_builtin.put("DATE", Boolean.TRUE);
        m_builtin.put("BOOLEAN", Boolean.TRUE);
    }
}

