/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class MethodInfo {
    public String methodName;
    public String methodNo;
    public String methodType;
    public int parameters;
    public int results;

    public MethodInfo(UserArguments row) throws SQLException {
        this.methodName = row.OBJECT_NAME;
        this.methodNo = row.OVERLOAD;
        this.methodType = "PUBLIC";
        this.parameters = row.sequence == 0 ? 0 : row.POSITION;
        if (this.parameters < 0) {
            this.parameters = 0;
        }
        this.results = 1 - row.POSITION;
        if (this.results < 0) {
            this.results = 0;
        }
    }

    public MethodInfo(AllTypeMethods row) throws SQLException {
        this.methodName = row.methodName;
        this.methodNo = row.methodNo;
        this.methodType = row.methodType;
        this.parameters = row.parameters;
        this.results = row.results;
    }

    public static MethodInfo[] getMethodInfo(Iterator iter) throws SQLException {
        Vector<MethodInfo> a = new Vector<MethodInfo>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof AllArguments) {
                a.addElement(new MethodInfo((AllArguments)obj));
                continue;
            }
            if (obj instanceof UserArguments) {
                a.addElement(new MethodInfo((UserArguments)obj));
                continue;
            }
            a.addElement(new MethodInfo((AllTypeMethods)obj));
        }
        MethodInfo[] r = new MethodInfo[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            r[i] = (MethodInfo)a.elementAt(i);
        }
        return r;
    }

    public static MethodInfo[] groupBy(Iterator iter) throws SQLException {
        MethodInfo[] minfo = MethodInfo.getMethodInfo(iter);
        Hashtable<String, MethodInfo> ht = new Hashtable<String, MethodInfo>();
        for (int i = 0; i < minfo.length; ++i) {
            String key = minfo[i].methodName + "," + minfo[i].methodNo;
            MethodInfo mi = (MethodInfo)ht.get(key);
            if (mi == null) {
                ht.put(key, minfo[i]);
            }
            if (mi != null && mi.parameters < minfo[i].parameters) {
                mi.parameters = minfo[i].parameters;
            }
            if (mi == null || mi.results >= minfo[i].results) continue;
            mi.results = minfo[i].results;
        }
        minfo = new MethodInfo[ht.size()];
        Enumeration htEnum = ht.elements();
        int i = 0;
        while (htEnum.hasMoreElements()) {
            minfo[i++] = (MethodInfo)htEnum.nextElement();
        }
        return minfo;
    }
}

