/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class OracleHelper {
    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, String username, DatabasePlatform platform, String originalCatalogPattern, String originalSchemaPattern, String originalProcedurePattern, DBWSBuilder builder) {
        ArrayList<DbStoredProcedure> dbStoredProcedures = null;
        String packageName = Util.escapePunctuation(originalCatalogPattern, true);
        String schemaPattern = Util.escapePunctuation(originalSchemaPattern, true);
        final String procedurePattern = Util.escapePunctuation(originalProcedurePattern, true);
        if (schemaPattern == null || schemaPattern.length() == 0) {
            schemaPattern = username;
        }
        SqlReflector sqlReflector = new SqlReflector(connection, username);
        try {
            SqlTypeWithMethods typ = (SqlTypeWithMethods)sqlReflector.addSqlUserType(schemaPattern, packageName, 4, true, 0, 0, new MethodFilter(){

                @Override
                public boolean acceptMethod(Method method, boolean preApprove) {
                    String methodName = method.getName();
                    return Util.sqlMatch(procedurePattern, methodName);
                }
            });
            Method[] methods = typ.getDeclaredMethods();
            if (methods.length > 0) {
                builder.setSqlType(typ);
                dbStoredProcedures = new ArrayList<DbStoredProcedure>();
                for (Method m : methods) {
                    DbStoredProcedure dbStoredProcedure = null;
                    Type returnType = m.getReturnType();
                    if (returnType == null) {
                        dbStoredProcedure = new DbStoredProcedure(m.getName());
                    } else {
                        dbStoredProcedure = new DbStoredFunction(m.getName());
                        DbStoredArgument dbStoredArgument = new DbStoredArgument(returnType.getName());
                        dbStoredArgument.setInOut(Util.InOut.RETURN);
                        dbStoredArgument.setSeq(0);
                        dbStoredArgument.setJdbcType(returnType.getJdbcTypecode());
                        Name n = returnType.getNameObject();
                        String typeName = n instanceof SqlName ? ((SqlName)n).getTypeName() : n.getSimpleName();
                        dbStoredArgument.setJdbcTypeName(typeName);
                        ((DbStoredFunction)dbStoredProcedure).setReturnArg(dbStoredArgument);
                    }
                    dbStoredProcedure.setCatalog(packageName);
                    dbStoredProcedure.setSchema(originalSchemaPattern);
                    int l = m.getParamNames().length;
                    for (int i = 0; i < l; ++i) {
                        String argName = m.getParamNames()[i];
                        Type parameterType = m.getParamTypes()[i];
                        DbStoredArgument dbStoredArgument = null;
                        dbStoredArgument = parameterType.isPrimitive() ? new DbStoredArgument(argName) : new PLSQLStoredArgument(argName);
                        int mode = m.getParamModes()[i];
                        Util.InOut inOut = Util.InOut.IN;
                        if (mode == 2) {
                            inOut = Util.InOut.OUT;
                        } else if (mode == 3) {
                            inOut = Util.InOut.INOUT;
                        }
                        dbStoredArgument.setInOut(inOut);
                        dbStoredArgument.setSeq(i);
                        dbStoredArgument.setJdbcType(parameterType.getJdbcTypecode());
                        Name n = parameterType.getNameObject();
                        String typeName = n instanceof SqlName ? ((SqlName)n).getTypeName() : n.getSimpleName();
                        if (parameterType.isPrimitive()) {
                            dbStoredArgument.setJdbcTypeName(typeName);
                        } else {
                            PLSQLStoredArgument plSqlArg = (PLSQLStoredArgument)dbStoredArgument;
                            plSqlArg.setPlSqlTypeName(typeName);
                            plSqlArg.setJdbcTypeName(n.getSimpleName());
                        }
                        dbStoredProcedure.getArguments().add(dbStoredArgument);
                    }
                    dbStoredProcedures.add(dbStoredProcedure);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return dbStoredProcedures;
    }

    public static QName getXMLTypeFromJDBCType(DbStoredArgument arg, String targetNamespace) {
        if (2003 == arg.getJdbcType() || 2002 == arg.getJdbcType()) {
            return new QName(targetNamespace, arg.getJdbcTypeName());
        }
        return Util.getXMLTypeFromJDBCType(arg.getJdbcType());
    }
}

