/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReportQuery
extends MWAbstractQuery
implements MWRelationalQuery,
MWOrderableQuery {
    private volatile MWRelationalSpecificQueryOptions relationalOptions;
    private ReturnChoiceOption returnChoice;
    public static final String RETURN_CHOICE_PROPERTY = "returnChoice";
    public static final String RETURN_SINGLE_RESULT = "returnSingleResult";
    public static final String RETURN_SINGLE_VALUE = "returnSingleValue";
    public static final String RETURN_SINGLE_ATTRIBUTE = "returnSingleAttribute";
    public static final String RETURN_RESULT_COLLECTION = "returnResultCollection";
    public static final String DEFAULT_RETURN_CHOICE = "returnResultCollection";
    private static TopLinkOptionSet returnChoiceOptions;
    private RetrievePrimaryKeysOption retrievePrimaryKeys;
    public static final String NO_PRIMARY_KEY = "noPrimaryKey";
    public static final String FULL_PRIMARY_KEY = "fullPrimaryKey";
    public static final String FIRST_PRIMARY_KEY = "firstPrimaryKey";
    public static final String DEFAULT_RETRIEVE_PRIMARY_KEYS = "noPrimaryKey";
    public static final String RETRIVE_PRIMARY_KEYS_PROPERTY = "retrievePrimaryKeys";
    private static TopLinkOptionSet retrievePrimaryKeysOptions;
    private List attributeItems;
    public static final String ATTRIBUTE_ITEMS_LIST = "attributeItems";
    private List groupingItems;
    public static final String GROUPING_ITEMS_LIST = "groupingItems";
    private List orderingItems;
    public static final String ORDERING_ITEMS_LIST = "orderingItems";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWReportQuery.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(MWAbstractQuery.class);
        XMLCompositeCollectionMapping attributeItemsMapping = new XMLCompositeCollectionMapping();
        attributeItemsMapping.setAttributeName(ATTRIBUTE_ITEMS_LIST);
        attributeItemsMapping.setReferenceClass(MWReportAttributeItem.class);
        attributeItemsMapping.setXPath("attributes/attribute-item");
        descriptor.addMapping((DatabaseMapping)attributeItemsMapping);
        XMLCompositeCollectionMapping groupingItemsMapping = new XMLCompositeCollectionMapping();
        groupingItemsMapping.setAttributeName(GROUPING_ITEMS_LIST);
        groupingItemsMapping.setReferenceClass(MWGroupingItem.class);
        groupingItemsMapping.setXPath("groupings/grouping");
        descriptor.addMapping((DatabaseMapping)groupingItemsMapping);
        XMLCompositeCollectionMapping orderingItemsMapping = new XMLCompositeCollectionMapping();
        orderingItemsMapping.setAttributeName(ORDERING_ITEMS_LIST);
        orderingItemsMapping.setReferenceClass(MWReportOrderingItem.class);
        orderingItemsMapping.setXPath("orderings/ordering");
        descriptor.addMapping((DatabaseMapping)orderingItemsMapping);
        XMLCompositeObjectMapping relationalOptionsMaping = new XMLCompositeObjectMapping();
        relationalOptionsMaping.setAttributeName("relationalOptions");
        relationalOptionsMaping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        relationalOptionsMaping.setXPath("relational-options");
        descriptor.addMapping((DatabaseMapping)relationalOptionsMaping);
        XMLDirectMapping returnChoiceMapping = new XMLDirectMapping();
        returnChoiceMapping.setAttributeName(RETURN_CHOICE_PROPERTY);
        returnChoiceMapping.setXPath("return-choice/text()");
        ObjectTypeConverter returnChoiceConverter = new ObjectTypeConverter();
        MWReportQuery.returnChoiceOptions().addConversionValuesForTopLinkTo(returnChoiceConverter);
        returnChoiceMapping.setConverter((Converter)returnChoiceConverter);
        returnChoiceMapping.setNullValue((Object)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption("returnResultCollection"));
        descriptor.addMapping((DatabaseMapping)returnChoiceMapping);
        XMLDirectMapping retrievePrimaryKeysMapping = new XMLDirectMapping();
        retrievePrimaryKeysMapping.setAttributeName(RETRIVE_PRIMARY_KEYS_PROPERTY);
        retrievePrimaryKeysMapping.setXPath("retrieve-primary-keys/text()");
        ObjectTypeConverter retrievePrimaryKeysConverter = new ObjectTypeConverter();
        MWReportQuery.retrievePrimaryKeysOptions().addConversionValuesForTopLinkTo(retrievePrimaryKeysConverter);
        retrievePrimaryKeysMapping.setConverter((Converter)retrievePrimaryKeysConverter);
        retrievePrimaryKeysMapping.setNullValue((Object)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption("noPrimaryKey"));
        descriptor.addMapping((DatabaseMapping)retrievePrimaryKeysMapping);
        return descriptor;
    }

    public static synchronized TopLinkOptionSet returnChoiceOptions() {
        if (returnChoiceOptions == null) {
            ArrayList<ReturnChoiceOption> list = new ArrayList<ReturnChoiceOption>();
            list.add(new ReturnChoiceOption("returnResultCollection", "RESULT_COLLECTION_RETURN_OPTION"));
            list.add(new ReturnChoiceOption(RETURN_SINGLE_RESULT, "SINGLE_RESULT_RETURN_OPTION"));
            list.add(new ReturnChoiceOption(RETURN_SINGLE_VALUE, "SINGLE_VALUE_RETURN_OPTION"));
            list.add(new ReturnChoiceOption(RETURN_SINGLE_ATTRIBUTE, "SINGLE_ATTRIBUTE_RETURN_OPTION"));
            returnChoiceOptions = new TopLinkOptionSet(list);
        }
        return returnChoiceOptions;
    }

    public static synchronized TopLinkOptionSet retrievePrimaryKeysOptions() {
        if (retrievePrimaryKeysOptions == null) {
            ArrayList<RetrievePrimaryKeysOption> list = new ArrayList<RetrievePrimaryKeysOption>();
            list.add(new RetrievePrimaryKeysOption("noPrimaryKey", "NO_PRIMARY_KEY_OPTION"));
            list.add(new RetrievePrimaryKeysOption(FULL_PRIMARY_KEY, "FULL_PRIMARY_KEY_OPTION"));
            list.add(new RetrievePrimaryKeysOption(FIRST_PRIMARY_KEY, "FIRST_PRIMARY_KEY_OPTION"));
            retrievePrimaryKeysOptions = new TopLinkOptionSet(list);
        }
        return retrievePrimaryKeysOptions;
    }

    private MWReportQuery() {
    }

    MWReportQuery(MWQueryManager queryManager, String name) {
        super(queryManager, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.returnChoice = (ReturnChoiceOption)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption("returnResultCollection");
        this.retrievePrimaryKeys = (RetrievePrimaryKeysOption)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption("noPrimaryKey");
        this.attributeItems = new Vector();
        this.groupingItems = new Vector();
        this.orderingItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.relationalOptions);
        List list = this.attributeItems;
        synchronized (list) {
            children.addAll(this.attributeItems);
        }
        list = this.groupingItems;
        synchronized (list) {
            children.addAll(this.groupingItems);
        }
        list = this.orderingItems;
        synchronized (list) {
            children.addAll(this.orderingItems);
        }
    }

    public MWReadAllQuery asReadAllQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadAllQuery newQuery = this.getQueryManager().addReadAllQuery(this.getName());
        ((MWAbstractQuery)((Object)newQuery)).initializeFrom(this);
        return newQuery;
    }

    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery newQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)newQuery)).initializeFrom(this);
        return newQuery;
    }

    public MWReportQuery asReportQuery() {
        return this;
    }

    public void initializeFrom(MWReadQuery query) {
        super.initializeFrom(query);
        this.initializeFrom((MWRelationalQuery)((Object)query));
    }

    public void initializeFrom(MWRelationalQuery query) {
        super.initializeFrom(query);
        this.getRelationalOptions().initializeFrom(query.getRelationalOptions());
    }

    public String queryType() {
        return "REPORT_QUERY";
    }

    public void formatSetToEjbql() {
        this.removeAttributeItems(this.attributeItems());
        this.removeOrderingItems(this.orderingItems());
        this.removeGroupingItems(this.groupingItems());
    }

    public void formatSetToSql() {
        this.removeOrderingItems(this.orderingItems());
        this.removeGroupingItems(this.groupingItems());
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String type) {
        this.relationalOptions.setQueryFormatType(type);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean cacheStatement) {
        this.relationalOptions.setCacheStatement(cacheStatement);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean bindAllParameters) {
        this.relationalOptions.setBindAllParameters(bindAllParameters);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bindAllParameters) {
        this.relationalOptions.setPrepare(bindAllParameters);
    }

    public ReturnChoiceOption getReturnChoice() {
        return this.returnChoice;
    }

    public void setReturnChoice(ReturnChoiceOption returnChoice) {
        ReturnChoiceOption oldObject = this.returnChoice;
        this.returnChoice = returnChoice;
        this.firePropertyChanged(RETURN_CHOICE_PROPERTY, oldObject, this.returnChoice);
    }

    public void setReturnChoice(String returnChoiceString) {
        this.setReturnChoice((ReturnChoiceOption)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption(returnChoiceString));
    }

    public RetrievePrimaryKeysOption getRetrievePrimaryKeys() {
        return this.retrievePrimaryKeys;
    }

    public void setRetrievePrimaryKeys(RetrievePrimaryKeysOption retrievePrimaryKeys) {
        RetrievePrimaryKeysOption oldObject = this.retrievePrimaryKeys;
        this.retrievePrimaryKeys = retrievePrimaryKeys;
        this.firePropertyChanged(RETRIVE_PRIMARY_KEYS_PROPERTY, oldObject, this.retrievePrimaryKeys);
    }

    public void setRetrievePrimaryKeys(String retrievePrimaryKeysString) {
        this.setRetrievePrimaryKeys((RetrievePrimaryKeysOption)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption(retrievePrimaryKeysString));
    }

    public MWReportAttributeItem addAttributeItem(String itemName, MWQueryable queryable) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem item = new MWReportAttributeItem((MWQuery)this, itemName, queryable);
            this.addAttributeItem(item);
            return item;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(String itemName, Iterator queryables) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem item = new MWReportAttributeItem((MWQuery)this, itemName, queryables);
            this.addAttributeItem(item);
            return item;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(String itemName, Iterator queryables, Iterator allowsNull) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem item = new MWReportAttributeItem(this, itemName, queryables, allowsNull);
            this.addAttributeItem(item);
            return item;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(int index, String itemName, Iterator queryables, Iterator allowsNull) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem item = new MWReportAttributeItem(this, itemName, queryables, allowsNull);
            this.addAttributeItem(index, item);
            return item;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    private boolean attributeItemsAllowed() {
        return this.getQueryFormat().reportAttributesAllowed();
    }

    private void addAttributeItem(MWReportAttributeItem attributeItem) {
        this.addAttributeItem(this.attributeItemsSize(), attributeItem);
    }

    private void addAttributeItem(int index, MWReportAttributeItem attributeItem) {
        this.addItemToList(index, attributeItem, this.attributeItems, ATTRIBUTE_ITEMS_LIST);
    }

    public void removeAttributeItem(MWReportAttributeItem attributeItem) {
        this.removeAttributeItem(this.attributeItems.indexOf(attributeItem));
    }

    public void removeAttributeItem(int index) {
        MWReportOrderingItem orderingItemToRemove = null;
        ListIterator i = this.orderingItems();
        while (i.hasNext()) {
            MWReportOrderingItem orderingItem = (MWReportOrderingItem)i.next();
            if (orderingItem.attributeItem() != this.attributeItems.get(index)) continue;
            orderingItemToRemove = orderingItem;
        }
        this.removeItemFromList(index, this.attributeItems, ATTRIBUTE_ITEMS_LIST);
        if (orderingItemToRemove != null) {
            this.removeOrderingItem(orderingItemToRemove);
        }
    }

    public void removeAttributeItems(Iterator attributeItems) {
        while (attributeItems.hasNext()) {
            this.removeAttributeItem((MWReportAttributeItem)attributeItems.next());
        }
    }

    public ListIterator attributeItems() {
        return new CloneListIterator(this.attributeItems);
    }

    public int attributeItemsSize() {
        return this.attributeItems.size();
    }

    public int indexOfAttributeItem(MWReportAttributeItem attributeItem) {
        return this.attributeItems.indexOf(attributeItem);
    }

    public void moveAttributeItemUp(MWReportAttributeItem item) {
        int index = this.indexOfAttributeItem(item);
        this.removeAttributeItem(index);
        this.addAttributeItem(index - 1, item);
    }

    public void moveAttributeItemDown(MWReportAttributeItem item) {
        int index = this.indexOfAttributeItem(item);
        this.removeAttributeItem(index);
        this.addAttributeItem(index + 1, item);
    }

    public MWGroupingItem addGroupingItem(MWQueryable queryable) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem item = new MWGroupingItem(this, queryable);
            this.addGroupingItem(item);
            return item;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(Iterator queryables) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem item = new MWGroupingItem(this, queryables);
            this.addGroupingItem(item);
            return item;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(Iterator queryables, Iterator allowsNull) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem item = new MWGroupingItem(this, queryables, allowsNull);
            this.addGroupingItem(item);
            return item;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(int index, Iterator queryables, Iterator allowsNull) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem item = new MWGroupingItem(this, queryables, allowsNull);
            this.addGroupingItem(index, item);
            return item;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    private boolean groupingAttribttesAllowed() {
        return this.getQueryFormat().groupingAtributesAllowed();
    }

    private void addGroupingItem(MWGroupingItem item) {
        this.addGroupingItem(this.groupingItemsSize(), item);
    }

    private void addGroupingItem(int index, MWGroupingItem item) {
        this.addItemToList(index, item, this.groupingItems, GROUPING_ITEMS_LIST);
    }

    public void removeGroupingItem(MWGroupingItem item) {
        this.removeGroupingItem(this.groupingItems.indexOf(item));
    }

    public void removeGroupingItem(int index) {
        this.removeItemFromList(index, this.groupingItems, GROUPING_ITEMS_LIST);
    }

    public void removeGroupingItems(Iterator groupingItems) {
        while (groupingItems.hasNext()) {
            this.removeGroupingItem((MWGroupingItem)groupingItems.next());
        }
    }

    public ListIterator groupingItems() {
        return new CloneListIterator(this.groupingItems);
    }

    public int groupingItemsSize() {
        return this.groupingItems.size();
    }

    public int indexOfGroupingItem(MWGroupingItem item) {
        return this.groupingItems.indexOf(item);
    }

    public void moveGroupingItemUp(MWGroupingItem item) {
        int index = this.indexOfGroupingItem(item);
        this.removeGroupingItem(index);
        this.addGroupingItem(index - 1, item);
    }

    public void moveGroupingItemDown(MWGroupingItem item) {
        int index = this.indexOfGroupingItem(item);
        this.removeGroupingItem(index);
        this.addGroupingItem(index + 1, item);
    }

    public Ordering addOrderingItem(MWQueryable queryable) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem orderingItem = new MWReportOrderingItem(this, queryable);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator queryables) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem orderingItem = new MWReportOrderingItem(this, queryables);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator queryables, Iterator allowsNull) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem orderingItem = new MWReportOrderingItem(this, queryables, allowsNull);
            this.addOrderingItem(orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(int index, Iterator queryables, Iterator allowsNull) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem orderingItem = new MWReportOrderingItem(this, queryables, allowsNull);
            this.addOrderingItem(index, orderingItem);
            return orderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWReportOrderingItem addOrderingItem(MWReportAttributeItem attributeItem) {
        MWReportOrderingItem item = new MWReportOrderingItem(this, attributeItem);
        this.addOrderingItem(item);
        return item;
    }

    private void addOrderingItem(Ordering orderingItem) {
        this.addOrderingItem(this.orderingItemsSize(), orderingItem);
    }

    private void addOrderingItem(int index, Ordering orderingItem) {
        this.addItemToList(index, orderingItem, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    private boolean orderingAttributesAllowed() {
        return this.getQueryFormat().orderingAttributesAllowed();
    }

    public void removeOrderingItem(Ordering orderingItem) {
        this.removeOrderingItem(this.orderingItems.indexOf(orderingItem));
    }

    public void removeOrderingItem(int index) {
        this.removeItemFromList(index, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItems(Iterator orderingItems) {
        while (orderingItems.hasNext()) {
            this.removeOrderingItem((Ordering)orderingItems.next());
        }
    }

    public ListIterator orderingItems() {
        return new CloneListIterator(this.orderingItems);
    }

    public int orderingItemsSize() {
        return this.orderingItems.size();
    }

    public int indexOfOrderingItem(Ordering orderingItem) {
        return this.orderingItems.indexOf(orderingItem);
    }

    public void moveOrderingItemUp(Ordering item) {
        int index = this.indexOfOrderingItem(item);
        this.removeOrderingItem(index);
        this.addOrderingItem(index - 1, item);
    }

    public void moveOrderingItemDown(Ordering item) {
        int index = this.indexOfOrderingItem(item);
        this.removeOrderingItem(index);
        this.addOrderingItem(index + 1, item);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    public DatabaseQuery runtimeQuery() {
        ReportQuery query = (ReportQuery)super.runtimeQuery();
        this.getReturnChoice().setMWOptionOnTopLinkObject(query);
        this.getRetrievePrimaryKeys().setMWOptionOnTopLinkObject(query);
        ListIterator i = this.attributeItems();
        while (i.hasNext()) {
            ((MWReportAttributeItem)i.next()).adjustRuntimeQuery((ObjectLevelReadQuery)query);
        }
        i = this.groupingItems();
        while (i.hasNext()) {
            ((MWGroupingItem)i.next()).adjustRuntimeQuery((ObjectLevelReadQuery)query);
        }
        i = this.orderingItems();
        while (i.hasNext()) {
            ((MWReportOrderingItem)i.next()).adjustRuntimeQuery((ObjectLevelReadQuery)query);
        }
        this.getRelationalOptions().adjustRuntimeQuery((ObjectLevelReadQuery)query);
        return query;
    }

    protected ObjectLevelReadQuery buildRuntimeQuery() {
        return new ReportQuery();
    }

    public static class RetrievePrimaryKeysOption
    extends TopLinkOption {
        private RetrievePrimaryKeysOption(String mwModelString, String externalString) {
            super(mwModelString, externalString);
        }

        public void setMWOptionOnTopLinkObject(Object query) {
            if (this.getMWModelOption() == MWReportQuery.FULL_PRIMARY_KEY) {
                ((ReportQuery)query).setShouldRetrievePrimaryKeys(true);
            } else if (this.getMWModelOption() == MWReportQuery.FIRST_PRIMARY_KEY) {
                ((ReportQuery)query).setShouldRetrieveFirstPrimaryKey(true);
            }
        }
    }

    public static class ReturnChoiceOption
    extends TopLinkOption {
        private ReturnChoiceOption(String mwModelString, String externalString) {
            super(mwModelString, externalString);
        }

        public void setMWOptionOnTopLinkObject(Object query) {
            String returnChoice = this.getMWModelOption();
            if (returnChoice == MWReportQuery.RETURN_SINGLE_ATTRIBUTE) {
                ((ReportQuery)query).returnSingleAttribute();
            } else if (returnChoice == MWReportQuery.RETURN_SINGLE_RESULT) {
                ((ReportQuery)query).returnSingleResult();
            } else if (returnChoice == MWReportQuery.RETURN_SINGLE_VALUE) {
                ((ReportQuery)query).returnSingleValue();
            } else if (returnChoice != "returnResultCollection") {
                throw new IllegalStateException();
            }
        }
    }
}

