/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodParams;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class ParamInfo {
    public String paramName;
    public String paramMode;
    public int paramNo;
    public String paramTypeName;
    public String paramTypeSubname;
    public boolean ncharFormOfUse;
    public String paramTypeOwner;
    public String paramTypeMod;
    public String methodName;
    public String methodNo;
    public int sequence;
    public int dataLength;
    public int dataPrecision;
    public int dataScale;
    public int objectId;

    public ParamInfo(AllMethodParams r) throws SQLException {
        this.paramName = r.paramName;
        this.paramMode = r.paramMode;
        this.paramTypeMod = r.paramTypeMod;
        this.paramTypeOwner = r.paramTypeOwner;
        this.paramTypeName = r.paramTypeName;
        if ("PL/SQL BINARY INTEGER".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BINARY_INTEGER";
        } else if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BOOLEAN";
        } else if ("PL/SQL PLS INTEGER".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "PLS_INTEGER";
        } else if ("PL/SQL LONG".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "LONG";
        } else if ("PL/SQL LONG RAW".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "LONG RAW";
        } else if ("PL/SQL RAWID".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "RAWID";
        } else if ("PL/SQL URAWID".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "URAWID";
        }
        this.paramTypeSubname = null;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(r.characterSetName)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = r.methodName;
        this.methodNo = r.methodNo;
        this.sequence = -1;
        this.dataLength = 0;
        this.dataPrecision = 0;
        this.dataScale = 0;
    }

    public ParamInfo(UserArguments r) throws SQLException {
        this.paramName = r.ARGUMENT_NAME;
        this.paramNo = r.POSITION;
        this.paramMode = r.IN_OUT;
        if ("IN/OUT".equalsIgnoreCase(this.paramMode)) {
            this.paramMode = "IN OUT";
        }
        this.paramTypeMod = "";
        if ("REF".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(r.DATA_TYPE) || "VARRAY".equalsIgnoreCase(r.DATA_TYPE) || "TABLE".equalsIgnoreCase(r.DATA_TYPE)) {
            this.paramTypeMod = r.DATA_TYPE;
        }
        this.paramTypeOwner = r.TYPE_OWNER;
        if ("PUBLIC".equalsIgnoreCase(this.paramTypeOwner)) {
            this.paramTypeOwner = "SYS";
        }
        this.paramTypeName = r.TYPE_NAME;
        if (SqlReflector.isNull(this.paramTypeName)) {
            this.paramTypeName = r.PLS_TYPE;
        }
        if (SqlReflector.isNull(this.paramTypeName)) {
            this.paramTypeName = r.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.paramTypeName)) {
            this.paramTypeName = "BOOLEAN";
        }
        this.paramTypeSubname = r.TYPE_SUBNAME;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(r.CHARACTER_SET_NAME)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = r.OBJECT_NAME;
        this.methodNo = r.OVERLOAD;
        this.sequence = r.sequence;
        this.dataLength = r.DATA_LENGTH;
        this.dataPrecision = r.DATA_PRECISION;
        this.dataScale = r.DATA_SCALE;
        this.objectId = r.OBJECT_ID;
    }

    public static ParamInfo[] getParamInfo(Iterator iter) throws SQLException {
        ArrayList a = new ArrayList();
        while (iter.hasNext()) {
            a.add(iter.next());
        }
        return ParamInfo.getParamInfo(a);
    }

    public static ParamInfo[] getParamInfo(ArrayList v) throws SQLException {
        ArrayList<ParamInfo> a = new ArrayList<ParamInfo>();
        for (int i = 0; i < v.size(); ++i) {
            Object obj = v.get(i);
            if (obj instanceof AllMethodParams) {
                a.add(new ParamInfo((AllMethodParams)obj));
                continue;
            }
            a.add(new ParamInfo((UserArguments)obj));
        }
        ParamInfo[] r = new ParamInfo[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            r[i] = (ParamInfo)a.get(i);
        }
        return r;
    }
}

