/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.ServerSession;

public class CacheImpl {
    private IdentityMapAccessor imap;
    private EntityManagerFactoryImpl emf;
    private ServerSession serversession;

    public CacheImpl(EntityManagerFactoryImpl emf, IdentityMapAccessor imap) {
        this.imap = imap;
        this.emf = emf;
        this.serversession = emf.getServerSession();
    }

    public boolean contains(Class cls, Object primaryKey) {
        this.emf.verifyOpen();
        return this.imap.containsObjectInIdentityMap(this.createPKVector(cls, primaryKey), cls);
    }

    public void evict(Class cls, Object primaryKey) {
        this.emf.verifyOpen();
        this.imap.invalidateObject(this.createPKVector(cls, primaryKey), cls);
    }

    public void evict(Class cls) {
        this.emf.verifyOpen();
        this.imap.invalidateClass(cls);
    }

    public void evictAll() {
        this.emf.verifyOpen();
        this.imap.invalidateAll();
    }

    private Vector createPKVector(Class cls, Object primaryKey) {
        ClassDescriptor cdesc = this.serversession.getDescriptor(cls);
        CMP3Policy cmp = (CMP3Policy)cdesc.getCMPPolicy();
        Vector pk = cmp.createPkVectorFromKey(primaryKey, (AbstractSession)this.serversession);
        return pk;
    }
}

