/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.transformers.MetadataHelper;
import org.eclipse.persistence.mappings.TransformationMapping;

public class ReadTransformerMetadata
extends ORMetadata {
    private Class m_transformerClass;
    private String m_transformerClassName;
    private String m_method;

    public ReadTransformerMetadata() {
        super("<read-transformer>");
    }

    protected ReadTransformerMetadata(String xmlElement) {
        super(xmlElement);
    }

    public ReadTransformerMetadata(Annotation readTransformer, MetadataAccessibleObject accessibleObject) {
        super(readTransformer, accessibleObject);
        if (readTransformer != null) {
            this.m_transformerClass = (Class)MetadataHelper.invokeMethod("transformerClass", readTransformer);
            this.m_method = (String)MetadataHelper.invokeMethod("method", readTransformer);
        }
    }

    public String getMethod() {
        return this.m_method;
    }

    public Class getTransformerClass() {
        return this.m_transformerClass;
    }

    public String getTransformerClassName() {
        return this.m_transformerClassName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_transformerClass = this.initXMLClassName(this.m_transformerClassName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TransformationMapping mapping, String annotatedElementName) {
        if (this.m_method == null || this.m_method.equals("")) {
            if (this.m_transformerClass.equals(Void.TYPE)) {
                throw ValidationException.readTransformerHasNeitherClassNorMethod((String)annotatedElementName);
            }
            if (!MetadataHelper.classImplementsInterface(this.m_transformerClass, "org.eclipse.persistence.mappings.transformers.AttributeTransformer")) throw ValidationException.readTransformerClassDoesntImplementAttributeTransformer((String)annotatedElementName);
            mapping.setAttributeTransformerClassName(this.m_transformerClass.getName());
            return;
        } else {
            if (!this.m_transformerClass.equals(Void.TYPE)) throw ValidationException.readTransformerHasBothClassAndMethod((String)annotatedElementName);
            mapping.setAttributeTransformation(this.m_method);
        }
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public void setTransformerClass(Class transformerClass) {
        this.m_transformerClass = transformerClass;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.m_transformerClassName = transformerClassName;
    }
}

