/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Range;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;

public class SortedListValueModelAdapter
extends CollectionListValueModelAdapter {
    protected Comparator comparator;

    public SortedListValueModelAdapter(CollectionValueModel collectionHolder, Comparator comparator) {
        super(collectionHolder);
        this.comparator = comparator;
    }

    public SortedListValueModelAdapter(CollectionValueModel collectionHolder) {
        this(collectionHolder, null);
    }

    public SortedListValueModelAdapter(ListValueModel listHolder, Comparator comparator) {
        this(new ListCollectionValueModelAdapter(listHolder), comparator);
    }

    public SortedListValueModelAdapter(ListValueModel listHolder) {
        this(listHolder, null);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.sortList();
    }

    protected void postBuildList() {
        super.postBuildList();
        Collections.sort(this.list, this.comparator);
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        super.itemsAdded(e);
        this.sortList();
    }

    protected void sortList() {
        ArrayList unsortedList = (ArrayList)this.list.clone();
        Collections.sort(this.list, this.comparator);
        Range diffRange = CollectionTools.identityDiffRange((List)unsortedList, (List)this.list);
        if (diffRange.size > 0) {
            List unsortedItems = unsortedList.subList(diffRange.start, diffRange.end + 1);
            List sortedItems = this.list.subList(diffRange.start, diffRange.end + 1);
            this.fireItemsReplaced("value", diffRange.start, sortedItems, unsortedItems);
        }
    }
}

