/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class OracleJDBC_10_1_0_2ProxyConnectionCustomizer
extends ConnectionCustomizer {
    protected OracleConnection oracleConnection;
    protected int proxyType;
    protected Properties proxyProperties;

    public OracleJDBC_10_1_0_2ProxyConnectionCustomizer(Accessor accessor, Session session) {
        super(accessor, session);
    }

    public void customize() {
        Connection connection;
        if (this.proxyProperties == null) {
            this.buildProxyProperties();
        }
        if ((connection = this.accessor.getConnection()) instanceof OracleConnection) {
            this.oracleConnection = (OracleConnection)connection;
        } else {
            connection = this.session.getServerPlatform().unwrapConnection(connection);
            if (connection instanceof OracleConnection) {
                this.oracleConnection = (OracleConnection)connection;
            } else {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnection();
            }
        }
        try {
            this.clearConnectionCache();
            this.oracleConnection.openProxySession(this.proxyType, this.proxyProperties);
        }
        catch (SQLException sQLException) {
            this.oracleConnection = null;
            throw DatabaseException.sqlException(sQLException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.oracleConnection = null;
            throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnectionVersion();
        }
    }

    public boolean isActive() {
        return this.oracleConnection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.clearConnectionCache();
            this.oracleConnection.close(1);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.oracleConnection = null;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone not supported");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OracleJDBC_10_1_0_2ProxyConnectionCustomizer) {
            return this.equals((OracleJDBC_10_1_0_2ProxyConnectionCustomizer)object);
        }
        return false;
    }

    public boolean equals(OracleJDBC_10_1_0_2ProxyConnectionCustomizer oracleJDBC_10_1_0_2ProxyConnectionCustomizer) {
        if (this == oracleJDBC_10_1_0_2ProxyConnectionCustomizer) {
            return true;
        }
        if (this.proxyProperties == null) {
            this.buildProxyProperties();
        }
        if (oracleJDBC_10_1_0_2ProxyConnectionCustomizer.proxyProperties == null) {
            oracleJDBC_10_1_0_2ProxyConnectionCustomizer.buildProxyProperties();
        }
        return this.proxyType == oracleJDBC_10_1_0_2ProxyConnectionCustomizer.proxyType && this.proxyProperties.equals(oracleJDBC_10_1_0_2ProxyConnectionCustomizer.proxyProperties);
    }

    protected void buildProxyProperties() {
        Object object;
        Object object2;
        Object object3 = this.session.getProperty("eclipselink.oracle.proxy-type");
        try {
            this.proxyType = (Integer)this.session.getPlatform().getConversionManager().convertObject(object3, Integer.class);
        }
        catch (ConversionException conversionException) {
            throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresIntProxytype();
        }
        this.proxyProperties = new Properties();
        if (this.proxyType == 1) {
            object2 = (String)this.session.getProperty("PROXY_USER_NAME");
            if (object2 != null) {
                this.proxyProperties.setProperty("PROXY_USER_NAME", (String)object2);
            } else {
                ValidationException.expectedProxyPropertyNotFound("OracleConnection.PROXYTYPE_USER_NAME", "PROXY_USER_NAME");
            }
        } else if (this.proxyType == 2) {
            object2 = (String)this.session.getProperty("PROXY_DISTINGUISHED_NAME");
            if (object2 != null) {
                this.proxyProperties.setProperty("PROXY_DISTINGUISHED_NAME", (String)object2);
            } else {
                ValidationException.expectedProxyPropertyNotFound("OracleConnection.PROXYTYPE_DISTINGUISHED_NAME", "PROXY_DISTINGUISHED_NAME");
            }
        } else if (this.proxyType == 3) {
            object2 = this.session.getProperty("PROXY_CERTIFICATE");
            if (object2 != null) {
                this.proxyProperties.put("PROXY_CERTIFICATE", object2);
            } else {
                ValidationException.expectedProxyPropertyNotFound("OracleConnection.PROXYTYPE_CERTIFICATE", "PROXY_CERTIFICATE");
            }
        } else {
            ValidationException.unknownProxyType(this.proxyType, "OracleConnection.PROXYTYPE_USER_NAME", "OracleConnection.PROXYTYPE_DISTINGUISHED_NAME", "OracleConnection.PROXYTYPE_CERTIFICATE");
        }
        object2 = (String)this.session.getProperty("PROXY_USER_PASSWORD");
        if (object2 != null && ((String)object2).length() > 0) {
            this.proxyProperties.setProperty("PROXY_USER_PASSWORD", (String)object2);
        }
        if (!((object = this.session.getProperty("PROXY_ROLES")) == null || object instanceof String && ((String)object).length() == 0)) {
            this.proxyProperties.put("PROXY_ROLES", object);
        }
    }

    protected void clearConnectionCache() {
        this.getSession().getServerPlatform().clearStatementCache(this.getAccessor().getConnection());
        ((DatabaseAccessor)this.getAccessor()).clearStatementCache((AbstractSession)this.getSession());
    }
}

