/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class DynamicClassWriter {
    private Class parentClass;
    private String className;
    private SDOType type;
    private HelperContext aHelperContext;

    public DynamicClassWriter(String className, SDOType type, HelperContext aContext) {
        this.aHelperContext = aContext;
        this.parentClass = SDODataObject.class;
        this.className = className;
        this.type = type;
        this.initializeParentClass();
    }

    private void initializeParentClass() {
        if (this.type.isSubType()) {
            SDOType parentSDOType = (SDOType)this.type.getBaseTypes().get(0);
            String parentClassName = parentSDOType.getInstanceClassName() + "Impl";
            try {
                this.parentClass = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader().loadClass(parentClassName, parentSDOType);
            }
            catch (Exception e) {
                this.parentClass = null;
            }
            if (this.parentClass == null) {
                this.parentClass = SDODataObject.class;
            }
        } else {
            this.parentClass = SDODataObject.class;
        }
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public String getClassName() {
        return this.className;
    }

    public byte[] createClass() {
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, this.className.replace('.', '/'), Type.getType((Class)this.parentClass).getInternalName(), null, null);
        this.addConstructors(cw);
        this.addWriteReplace(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void addConstructors(ClassWriter cw) {
        CodeVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), new String[]{Type.getInternalName(Serializable.class)}, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getType((Class)this.parentClass).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
    }

    private void addWriteReplace(ClassWriter cw) {
        Method method;
        try {
            method = this.parentClass.getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        CodeVisitor mv = cw.visitMethod(4, method.getName(), Type.getMethodDescriptor((Method)method), new String[]{Type.getInternalName(ObjectStreamException.class)}, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass), method.getName(), Type.getMethodDescriptor((Method)method));
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
    }
}

