/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

final class MetadataHelper {
    MetadataHelper() {
    }

    public static boolean classImplementsInterface(Class cls, String iFaceName) {
        Class<?>[] interfaces;
        if (cls.getName().contains(iFaceName)) {
            return true;
        }
        for (Class<?> iFace : interfaces = cls.getInterfaces()) {
            if (!iFace.getName().contains(iFaceName)) continue;
            return true;
        }
        for (Class<?> iFace : interfaces) {
            if (!MetadataHelper.classImplementsInterface(iFace, iFaceName)) continue;
            return true;
        }
        Class superClass = cls.getSuperclass();
        if (cls == null) {
            return false;
        }
        return MetadataHelper.classImplementsInterface(superClass, iFaceName);
    }

    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), (String)methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)method, (Object)target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)ex2);
            }
        }
        return null;
    }
}

