/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Sortable;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class Field
implements Sortable {
    private String m_name;
    private Type m_type;
    private int m_dataLength;
    private int m_precision;
    private int m_scale;
    private boolean m_isNChar;
    private SqlReflector m_reflector;

    public Field(String name, Type type, int dataLength, int precision, int scale, boolean ncharFormOfUse, SqlReflector reflector) {
        this.m_name = name;
        this.m_type = type;
        this.m_dataLength = dataLength;
        this.m_precision = precision;
        this.m_scale = scale;
        this.m_reflector = reflector;
        this.m_isNChar = ncharFormOfUse;
    }

    public Field(String name, Type type, int dataLength, int precision, int scale, String character_set_name, SqlReflector reflector) {
        this(name, type, dataLength, precision, scale, "NCHAR_CS".equals(character_set_name), reflector);
    }

    public String getName() {
        return this.m_name;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getDataLength() {
        return this.m_dataLength;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }

    public boolean isNChar() {
        return this.m_isNChar;
    }

    public String printTypeWithLength() {
        String typeName = this.m_type.getName();
        if (this.m_type instanceof SqlType) {
            typeName = ((SqlType)this.m_type).getTargetTypeName();
        }
        return Util.printTypeWithLength(typeName, this.m_dataLength, this.m_precision, this.m_scale);
    }

    public String printTypeWithLength(int schemaName) {
        String typeName = this.m_type.getName();
        if (this.m_type instanceof SqlType && ((SqlType)this.m_type).getSqlName() != null) {
            typeName = ((SqlType)this.m_type).getSqlName().getFullTargetTypeName(schemaName);
        }
        return Util.printTypeWithLength(typeName, this.m_dataLength, this.m_precision, this.m_scale);
    }

    public String toString() {
        return this.m_type.toString() + " " + this.m_name;
    }

    @Override
    public String getSortingKey() {
        return this.getName();
    }
}

