/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Map;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SerializableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public class PLSQLMap
extends Map {
    public PLSQLMap(Type s, SqlReflector reflector) {
        super(s, reflector);
        this.mapInit();
    }

    @Override
    void mapInit() {
        this.bfileMap = 7;
        this.cursorMap = 34;
        this.rowidMap = 14;
    }

    @Override
    public String writeTypeName(Type type) {
        return this.writeTypeName2(type, false);
    }

    @Override
    public String writeTypeName(Type type, boolean intfIfPossible) {
        return this.writeTypeName2(type, intfIfPossible);
    }

    private String writeTypeName2(Type type, boolean itfIfPossible) {
        if (type instanceof JavaType) {
            return ((JavaType)type).getTypeName(this);
        }
        if (type instanceof SerializableType) {
            return ((SerializableType)type).getFullDeclClass();
        }
        SqlType sqlType = (SqlType)type;
        String predefinedName = null;
        if (sqlType == null) {
            return null;
        }
        String sql = sqlType.getSqlName() == null ? null : sqlType.getSqlName().toString();
        predefinedName = sql != null && this.m_reflector.getTypeMap().get(sql) != null ? ((SqlType)this.m_reflector.getTypeMap().get(sql)).getSqlName().getUseClass(this.m_package) : this.writePredefinedName(sqlType.getJdbcTypecode());
        if (predefinedName != null) {
            return predefinedName;
        }
        if (sqlType.isRef()) {
            return this.writeTypeName(sqlType) + "Ref";
        }
        SqlName sqlName = sqlType.getSqlName();
        return PLSQLMap.interfaceIfPossible(sqlName, this.m_package, itfIfPossible);
    }

    private static String interfaceIfPossible(SqlName sqlName, String mpackage, boolean itfIfPossible) {
        if (itfIfPossible && sqlName.hasUseItf()) {
            return sqlName.getUseItf(mpackage);
        }
        if (sqlName.hasUseClass()) {
            return sqlName.getUseClass(mpackage);
        }
        if (itfIfPossible && sqlName.hasDeclItf()) {
            return sqlName.getDeclItf(mpackage);
        }
        return sqlName.getDeclClass(mpackage);
    }

    @Override
    public String getMemberName(String sqlName, boolean wordBoundary, boolean onlyIfRegistered, Name name) {
        String s = null;
        if (this.m_field_map != null && (s = (String)this.m_field_map.get(sqlName)) != null) {
            if (s.equals("null")) {
                return null;
            }
            return s;
        }
        return onlyIfRegistered ? null : SqlName.sqlIdToJavaId(sqlName, wordBoundary, true);
    }

    @Override
    public String getMemberNameAsSuffix(String sqlName) {
        return this.getMemberName(sqlName, true, false);
    }
}

