/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class RowsCacheEntry
implements Externalizable {
    private String m_view;
    private String[] m_selects;
    private String[] m_keys;
    private Object[] m_values;
    private ArrayList m_rows;

    public RowsCacheEntry() {
    }

    public RowsCacheEntry(String view, String[] selects, String[] keys, Object[] values, ArrayList rows) {
        this.m_view = view;
        this.m_keys = keys;
        this.m_values = values;
        this.m_rows = rows;
        this.m_selects = selects;
    }

    public String getView() {
        return this.m_view;
    }

    public String[] getSelects() {
        return this.m_selects;
    }

    public String[] getKeys() {
        return this.m_keys;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public ArrayList getRows() {
        return this.m_rows;
    }

    public RowsCacheEntry compare(RowsCacheEntry to) {
        RowsCacheEntry diff = null;
        if (this.m_view.equals(to.getView()) && (this.m_selects.length == 0 || to.getSelects().length == 1) && this.m_keys.length < to.getKeys().length) {
            int j;
            boolean compatible = true;
            for (int i = 0; i < this.m_keys.length; ++i) {
                boolean match = false;
                for (j = 0; j < to.getKeys().length; ++j) {
                    if (this.m_keys[i].equals(to.getKeys()[j]) && i + 1 < this.m_keys.length && this.m_keys[i].equals(this.m_keys[i + 1]) && ("" + this.m_values[i]).equals("" + to.getValues()[j])) {
                        if (j + 1 < to.getKeys().length && to.getKeys()[j].equals(to.getKeys()[j + 1]) && ("" + this.m_values[i + 1]).equals("" + to.getValues()[j + 1])) {
                            ++i;
                            ++j;
                            match = true;
                            continue;
                        }
                        match = false;
                        break;
                    }
                    if (!this.m_keys[i].equals(to.getKeys()[j]) || !("" + this.m_values[i]).equals("" + to.getValues()[j])) continue;
                    match = true;
                }
                if (match) continue;
                compatible = false;
                break;
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (j = 0; j < to.getKeys().length; ++j) {
                boolean match = false;
                for (int i = 0; i < this.m_keys.length; ++i) {
                    if (!this.m_keys[i].equals(to.getKeys()[j])) continue;
                    match = true;
                }
                if (match) continue;
                keys.add(to.getKeys()[j]);
                values.add(to.getValues()[j]);
            }
            if (compatible) {
                diff = new RowsCacheEntry(this.m_view, this.m_selects, keys.toArray(new String[0]), values.toArray(new Object[0]), this.m_rows);
            }
        }
        return diff;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_view = (String)in.readObject();
        this.m_selects = (String[])in.readObject();
        this.m_keys = (String[])in.readObject();
        this.m_values = (Object[])in.readObject();
        int rowsSize = (Integer)in.readObject();
        this.m_rows = new ArrayList(rowsSize);
        for (int i = 0; i < rowsSize; ++i) {
            this.m_rows.add(in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_view);
        out.writeObject(this.m_selects);
        out.writeObject(this.m_keys);
        out.writeObject(this.m_values);
        out.writeObject(new Integer(this.m_rows.size()));
        for (int i = 0; i < this.m_rows.size(); ++i) {
            out.writeObject(this.m_rows.get(i));
        }
    }

    public String printSummary() {
        int i;
        String text = "";
        text = text + "  view: " + this.m_view + "\n";
        text = text + "  what: ";
        for (i = 0; i < this.m_selects.length; ++i) {
            text = text + this.m_selects[i] + " ";
        }
        text = text + "\n";
        text = text + "  where: ";
        for (i = 0; i < this.m_keys.length; ++i) {
            text = text + this.m_keys[i] + "=" + this.m_values[i] + " ";
        }
        text = text + "\n";
        text = text + "  rows: " + this.m_rows.size();
        return text;
    }
}

