/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.aq;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.sql.DataSource;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQSession;
import org.eclipse.persistence.internal.eis.adapters.aq.AQAdapterMetaData;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnection;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQRecordFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

public class AQConnectionFactory
implements ConnectionFactory {
    public javax.resource.cci.Connection getConnection() throws ResourceException {
        return this.getConnection(new AQConnectionSpec());
    }

    public javax.resource.cci.Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        AQSession aQSession;
        Connection connection;
        AQConnectionSpec aQConnectionSpec;
        try {
            aQConnectionSpec = (AQConnectionSpec)connectionSpec;
            if (aQConnectionSpec.hasDatasource()) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(aQConnectionSpec.getDatasource());
                connection = dataSource.getConnection();
            } else {
                connection = DriverManager.getConnection(aQConnectionSpec.getURL(), aQConnectionSpec.getUser(), aQConnectionSpec.getPassword());
                connection.setAutoCommit(false);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedClassForName("oracle.AQ.AQOracleDriver", true, this.getClass().getClassLoader()));
            } else {
                PrivilegedAccessHelper.getClassForName("oracle.AQ.AQOracleDriver", true, this.getClass().getClassLoader());
            }
            aQSession = AQDriverManager.createAQSession((Object)connection);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        return new AQConnection(aQSession, connection, aQConnectionSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new AQAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new AQRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

