/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAutoGeneratedQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StringQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

final class QuerySelectionCriteriaPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private PropertyValueModel relationalOptionsHolder;
    private PropertyValueModel queryFormatHolder;
    private AbstractQueryFormatPanel activeQueryFormatPanel;
    private AutoGeneratedQueryFormatPanel autoGeneratedQueryFormatPanel;
    private NonAutoGeneratedQueryFormatPanel nonAutoGeneratedQueryFormatPanel;
    private Map queryFormatPanelMap;

    QuerySelectionCriteriaPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.relationalOptionsHolder = this.buildRelationalOptionsHolder();
        this.queryFormatHolder = this.buildQueryFormatHolder();
        this.queryFormatHolder.addPropertyChangeListener("value", this.buildQueryFormatListener());
        this.initializeLayout();
        this.initializeMaps();
    }

    private PropertyValueModel buildQueryFormatHolder() {
        return new PropertyAspectAdapter(this.relationalOptionsHolder, "queryFormatType"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getQueryFormat();
            }
        };
    }

    private PropertyValueModel buildRelationalOptionsHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getRelationalOptions();
            }
        };
    }

    private PropertyChangeListener buildQueryFormatListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MWQueryFormat queryFormat = QuerySelectionCriteriaPanel.this.getQueryFormat();
                if (queryFormat != null) {
                    QuerySelectionCriteriaPanel.this.setActiveQueryFormatPanel((AbstractQueryFormatPanel)QuerySelectionCriteriaPanel.this.queryFormatPanelMap.get(queryFormat.getClass()));
                }
            }
        };
    }

    private void initializeLayout() {
        this.autoGeneratedQueryFormatPanel = new AutoGeneratedQueryFormatPanel(this.getApplicationContext());
        this.nonAutoGeneratedQueryFormatPanel = new NonAutoGeneratedQueryFormatPanel(this.getApplicationContext());
        this.setActiveQueryFormatPanel(this.nonAutoGeneratedQueryFormatPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private void initializeMaps() {
        this.queryFormatPanelMap = new Hashtable();
        this.queryFormatPanelMap.put(MWAutoGeneratedQueryFormat.class, this.autoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWExpressionQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWSQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
    }

    private String helpTopicId() {
        return "descriptor.queries.format";
    }

    private void setActiveQueryFormatPanel(AbstractQueryFormatPanel newQueryFormatPanel) {
        AbstractQueryFormatPanel oldQueryFormatPanel = this.activeQueryFormatPanel;
        if (newQueryFormatPanel == oldQueryFormatPanel) {
            return;
        }
        this.activeQueryFormatPanel = newQueryFormatPanel;
        if (oldQueryFormatPanel != null) {
            this.remove(oldQueryFormatPanel);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.activeQueryFormatPanel, constraints);
        this.revalidate();
        this.repaint();
    }

    private MWQueryFormat getQueryFormat() {
        return (MWQueryFormat)this.queryFormatHolder.getValue();
    }

    private boolean queryFormatCanChange() {
        boolean changeQueryType;
        String promptValue = TriStateBoolean.UNDEFINED.toString();
        String value = this.preferences().get("query change query format", promptValue);
        if (value.equals(promptValue)) {
            changeQueryType = this.promptToChangeSelectionCriteriaType();
        } else {
            changeQueryType = TriStateBoolean.TRUE.toString().equals(value);
            if (!changeQueryType) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("QUERY_FORMAT_CHANGE_DISSALLOWED"));
            }
        }
        return changeQueryType;
    }

    private boolean promptToChangeSelectionCriteriaType() {
        if (this.preferences().getBoolean("query change query format", false)) {
            return true;
        }
        String title = this.resourceRepository().getString("QUERY_QUERY_FORMAT_TITLE");
        String message = this.resourceRepository().getString("QUERY_QUERY_FORMAT_MESSAGE");
        SimplePropertyValueModel dontAskAgainHolder = new SimplePropertyValueModel(new Boolean(false));
        JComponent dontAskAgainPanel = SwingComponentFactory.buildDoNotAskAgainPanel(message, dontAskAgainHolder, this.resourceRepository());
        int response = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), dontAskAgainPanel, title, 0, 2);
        if (dontAskAgainHolder.getValue().equals(Boolean.TRUE)) {
            if (response == 0) {
                this.preferences().putBoolean("query change query format", true);
            } else if (response == 1) {
                this.preferences().putBoolean("query change query format", false);
            }
        }
        return response == 0;
    }

    private final class NonAutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        private PropertyValueModel queryFormatTypeHolder;
        private QueryFormatSubPanel activeQueryFormatSubPanel;
        private StringQueryFormatSubPanel stringQueryFormatPanel;
        private ExpressionQueryFormatSubPanel expressionPanel;
        private Map subQueryFormatPanelMap;

        public NonAutoGeneratedQueryFormatPanel(ApplicationContext context) {
            super(context);
            QuerySelectionCriteriaPanel.this.queryFormatHolder.addPropertyChangeListener("value", this.buildQueryFormatListener());
            this.queryFormatTypeHolder = this.buildQueryFormatTypeAdapter();
            this.initialize();
            this.initializeMaps();
        }

        private void initializeMaps() {
            this.subQueryFormatPanelMap = new Hashtable();
            this.subQueryFormatPanelMap.put(MWExpressionQueryFormat.class, this.expressionPanel);
            this.subQueryFormatPanelMap.put(MWSQLQueryFormat.class, this.stringQueryFormatPanel);
            this.subQueryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.stringQueryFormatPanel);
        }

        private void initialize() {
            JPanel queryFormatTypePanel = this.initializeQueryFormatTypePanel();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 0, 0, 5);
            this.add((Component)queryFormatTypePanel, constraints);
            this.stringQueryFormatPanel = new StringQueryFormatSubPanel(QuerySelectionCriteriaPanel.this.queryHolder, QuerySelectionCriteriaPanel.this.queryFormatHolder, QuerySelectionCriteriaPanel.this.getWorkbenchContextHolder());
            this.expressionPanel = new ExpressionQueryFormatSubPanel(QuerySelectionCriteriaPanel.this.queryHolder, QuerySelectionCriteriaPanel.this.queryFormatHolder, QuerySelectionCriteriaPanel.this.getWorkbenchContextHolder());
            this.setActiveQueryFormatSubPanel(this.stringQueryFormatPanel);
        }

        private JPanel initializeQueryFormatTypePanel() {
            ArrayList<JComponent> components = new ArrayList<JComponent>();
            JPanel queryFormatTypeRadioButtonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel typeLabel = new JLabel(this.resourceRepository().getString("SELECTION_CRITERIA_TYPE_LABEL"));
            components.add(typeLabel);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 5, 0, 0);
            queryFormatTypeRadioButtonPanel.add((Component)typeLabel, constraints);
            JComboBox comboBox = new JComboBox(this.buildSelectionCriteriaComboBoxModel());
            comboBox.setRenderer(this.buildSelectionCriteraComboBoxRenderer());
            components.add(comboBox);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 5, 0, 0);
            queryFormatTypeRadioButtonPanel.add(comboBox, constraints);
            new ComponentEnabler((ValueModel)this.buildQueryComponentEnableBooleanHolder(), components);
            return queryFormatTypeRadioButtonPanel;
        }

        private PropertyChangeListener buildQueryFormatListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    MWQueryFormat queryFormat = QuerySelectionCriteriaPanel.this.getQueryFormat();
                    if (queryFormat != null) {
                        NonAutoGeneratedQueryFormatPanel.this.setActiveQueryFormatSubPanel((QueryFormatSubPanel)NonAutoGeneratedQueryFormatPanel.this.subQueryFormatPanelMap.get(queryFormat.getClass()));
                    } else {
                        NonAutoGeneratedQueryFormatPanel.this.setActiveQueryFormatSubPanel((QueryFormatSubPanel)NonAutoGeneratedQueryFormatPanel.this.subQueryFormatPanelMap.get(MWSQLQueryFormat.class));
                    }
                }
            };
        }

        private ComboBoxModel buildSelectionCriteriaComboBoxModel() {
            return new ComboBoxModelAdapter(this.selectionCriteriaOptionsModel(), this.queryFormatTypeHolder);
        }

        private CollectionValueModel selectionCriteriaOptionsModel() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("expressionFormat");
            options.add("sqlFormat");
            options.add("ejbqlFormat");
            return new ReadOnlyCollectionValueModel(options);
        }

        private ListCellRenderer buildSelectionCriteraComboBoxRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object value) {
                    if ((String)value == "expressionFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EXPRESSION_OPTION");
                    }
                    if ((String)value == "sqlFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("SQL_OPTION");
                    }
                    return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EJBQL_OPTION");
                }
            };
        }

        private PropertyValueModel buildQueryFormatTypeAdapter() {
            return new PropertyAspectAdapter(QuerySelectionCriteriaPanel.this.relationalOptionsHolder, "queryFormatType"){

                protected Object getValueFromSubject() {
                    return ((MWRelationalQuery)this.subject).getQueryFormatType();
                }

                protected void setValueOnSubject(Object value) {
                    if (QuerySelectionCriteriaPanel.this.queryFormatCanChange()) {
                        ((MWRelationalQuery)this.subject).setQueryFormatType((String)value);
                    }
                }
            };
        }

        private PropertyValueModel buildQueryComponentEnableBooleanHolder() {
            return new PropertyAspectAdapter(QuerySelectionCriteriaPanel.this.queryHolder){

                protected Object buildValue() {
                    return this.subject != null;
                }
            };
        }

        private void setActiveQueryFormatSubPanel(QueryFormatSubPanel newQueryFormatPanel) {
            QueryFormatSubPanel oldQueryFormatPanel = this.activeQueryFormatSubPanel;
            if (newQueryFormatPanel == oldQueryFormatPanel) {
                return;
            }
            this.activeQueryFormatSubPanel = newQueryFormatPanel;
            if (oldQueryFormatPanel != null) {
                this.remove(oldQueryFormatPanel);
            }
            if (this.activeQueryFormatSubPanel != null) {
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                constraints.anchor = 10;
                constraints.insets = new Insets(5, 5, 5, 5);
                this.add((Component)this.activeQueryFormatSubPanel, constraints);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private final class AutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        public AutoGeneratedQueryFormatPanel(ApplicationContext context) {
            super(context);
            this.initialize();
        }

        protected void initialize() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel autoGenCommentArea = this.buildLabel("AUTO_GENERATED_QUERY_COMMENT");
            autoGenCommentArea.setFocusable(true);
            autoGenCommentArea.setRequestFocusEnabled(true);
            this.add((Component)autoGenCommentArea, "First");
        }
    }

    private abstract class AbstractQueryFormatPanel
    extends AbstractPanel {
        protected AbstractQueryFormatPanel(ApplicationContext context) {
            super(context);
        }
    }
}

