/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.command.CommandsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CommandsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JMSTopicTransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Oc4jJGroupsTransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMIIIOPTransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMITransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SunCORBATransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UserDefinedTransportManagerAdapter;

public class RemoteCommandManagerAdapter
extends SCAdapter {
    public static final String CHANNEL_PROPERTY = "channelConfig";
    private volatile CommandsAdapter commands;
    public static final String COMMANDS_PROPERTY = "commandsConfig";
    private volatile TransportManagerAdapter transportManager;
    public static final String TRANSPORT_MANAGER_PROPERTY = "transportManagerConfig";
    public static final String CACHE_SYNC_PROPERTY = "cacheSyncConfig";

    RemoteCommandManagerAdapter(SCAdapter parent, RemoteCommandManagerConfig scConfig) {
        super(parent, scConfig);
    }

    protected RemoteCommandManagerAdapter(SCAdapter parent) {
        super(parent);
    }

    private final RemoteCommandManagerConfig rcm() {
        return (RemoteCommandManagerConfig)this.getModel();
    }

    protected Object buildModel() {
        return new RemoteCommandManagerConfig();
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        if (this.transportManager != null) {
            children.add(this.getTransportManager());
        }
        if (this.commands != null) {
            children.add(this.getCommands());
        }
    }

    private CommandsAdapter buildCommands() {
        CommandsConfig commands = new CommandsConfig();
        this.rcm().setCommandsConfig(commands);
        return new CommandsAdapter((SCAdapter)this, commands);
    }

    private TransportManagerAdapter buildDefaultTransportManager() {
        return this.buildJMSTransportManager();
    }

    private JMSTopicTransportManagerAdapter buildJMSTransportManager() {
        return new JMSTopicTransportManagerAdapter(this);
    }

    private RMITransportManagerAdapter buildRMITransportManager() {
        return new RMITransportManagerAdapter(this);
    }

    private RMIIIOPTransportManagerAdapter buildRMIIIOPTransportManager() {
        return new RMIIIOPTransportManagerAdapter(this);
    }

    private UserDefinedTransportManagerAdapter buildUserDefinedTransportManager() {
        return new UserDefinedTransportManagerAdapter(this);
    }

    private SunCORBATransportManagerAdapter buildSunCORBATransportManager() {
        return new SunCORBATransportManagerAdapter(this);
    }

    private Oc4jJGroupsTransportManagerAdapter buildOc4jJGroupsTransportManager() {
        return new Oc4jJGroupsTransportManagerAdapter(this);
    }

    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.commands = (CommandsAdapter)this.adapt(this.rcm().getCommandsConfig());
        this.transportManager = (TransportManagerAdapter)this.adapt(this.rcm().getTransportManagerConfig());
    }

    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.commands = null;
        this.transportManager = null;
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setCacheSync(true);
        if (this.rcm().getChannel() == null) {
            this.setChannel("TopLinkCommandChannel");
        }
    }

    public TransportManagerAdapter getTransportManager() {
        if (this.transportManager == null) {
            this.setTransportManager(this.buildDefaultTransportManager());
        }
        return this.transportManager;
    }

    private void setTransportManager(TransportManagerAdapter manager) {
        TransportManagerAdapter old = this.transportManager;
        this.transportManager = manager;
        this.rcm().setTransportManagerConfig((TransportManagerConfig)manager.getModel());
        this.firePropertyChanged(TRANSPORT_MANAGER_PROPERTY, (Object)old, (Object)manager);
    }

    public String getChannel() {
        return this.rcm().getChannel();
    }

    public void setChannel(String value) {
        String old = this.rcm().getChannel();
        this.rcm().setChannel(value);
        this.firePropertyChanged(CHANNEL_PROPERTY, old, value);
    }

    public boolean usesCacheSync() {
        return this.getCommands().usesCacheSync();
    }

    private void setCacheSync(boolean cacheSync) {
        boolean old = this.getCommands().usesCacheSync();
        this.commands.setCacheSync(cacheSync);
        this.firePropertyChanged(CACHE_SYNC_PROPERTY, old, cacheSync);
    }

    CommandsAdapter getCommands() {
        if (this.commands == null) {
            this.setCommands(this.buildCommands());
        }
        return this.commands;
    }

    private void setCommands(CommandsAdapter commands) {
        CommandsAdapter old = this.commands;
        this.commands = commands;
        this.rcm().setCommandsConfig((CommandsConfig)commands.getModel());
        this.firePropertyChanged(COMMANDS_PROPERTY, (Object)old, (Object)commands);
    }

    public JMSTopicTransportManagerAdapter setTransportAsJMSTopic() {
        if (!(this.transportManager instanceof JMSTopicTransportManagerAdapter)) {
            this.setTransportManager(this.buildJMSTransportManager());
        }
        this.setChannel("TopLinkCommandChannel");
        return (JMSTopicTransportManagerAdapter)this.transportManager;
    }

    public RMITransportManagerAdapter setTransportAsRMI() {
        this.setTransportManager(this.buildRMITransportManager());
        return (RMITransportManagerAdapter)this.transportManager;
    }

    public RMIIIOPTransportManagerAdapter setTransportAsRMIIIOP() {
        this.setTransportManager(this.buildRMIIIOPTransportManager());
        return (RMIIIOPTransportManagerAdapter)this.transportManager;
    }

    public UserDefinedTransportManagerAdapter setTransportAsUserDefined() {
        this.setTransportManager(this.buildUserDefinedTransportManager());
        return (UserDefinedTransportManagerAdapter)this.transportManager;
    }

    public SunCORBATransportManagerAdapter setTransportAsSunCORBA() {
        this.setTransportManager(this.buildSunCORBATransportManager());
        return (SunCORBATransportManagerAdapter)this.transportManager;
    }

    public Oc4jJGroupsTransportManagerAdapter setTransportAsOc4jJGroups() {
        this.setTransportManager(this.buildOc4jJGroupsTransportManager());
        return (Oc4jJGroupsTransportManagerAdapter)this.transportManager;
    }
}

